/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.model.entity;

import com.klikli_dev.occultism.common.entity.familiar.GreedyFamiliarEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class GreedyFamiliarModel
extends EntityModel<GreedyFamiliarEntity> {
    private static final float PI = (float)Math.PI;
    public ModelPart body;
    public ModelPart rightArm;
    public ModelPart chest1;
    public ModelPart leftArm;
    public ModelPart rightLeg;
    public ModelPart leftLeg;
    public ModelPart head;
    public ModelPart chest2;
    public ModelPart monster;
    public ModelPart monsterLeftEye;
    public ModelPart monsterRightEye;
    public ModelPart monsterLeftEar;
    public ModelPart monsterRightEar;
    public ModelPart leftEar;
    public ModelPart rightEar;
    public ModelPart nose;

    public GreedyFamiliarModel(ModelPart part) {
        this.body = part.getChild("body");
        this.rightArm = this.body.getChild("rightArm");
        this.chest1 = this.body.getChild("chest1");
        this.leftArm = this.body.getChild("leftArm");
        this.rightLeg = this.body.getChild("rightLeg");
        this.leftLeg = this.body.getChild("leftLeg");
        this.head = this.body.getChild("head");
        this.chest2 = this.chest1.getChild("chest2");
        this.monster = this.chest1.getChild("monster");
        this.monsterLeftEye = this.monster.getChild("monsterLeftEye");
        this.monsterRightEye = this.monster.getChild("monsterRightEye");
        this.monsterLeftEar = this.monster.getChild("monsterLeftEar");
        this.monsterRightEar = this.monster.getChild("monsterRightEar");
        this.leftEar = this.head.getChild("leftEar");
        this.rightEar = this.head.getChild("rightEar");
        this.nose = this.head.getChild("nose");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.getRoot();
        PartDefinition body = parts.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 10).addBox(-2.5f, -5.0f, -1.5f, 5.0f, 5.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)0.6f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = body.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(16, 21).addBox(-2.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, true), PartPose.offsetAndRotation((float)-2.5f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition chest1 = body.addOrReplaceChild("chest1", CubeListBuilder.create().texOffs(12, 14).addBox(-2.0f, -3.0f, 0.0f, 4.0f, 3.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)1.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = body.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(16, 21).addBox(0.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, false), PartPose.offsetAndRotation((float)2.5f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightLeg = body.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(8, 24).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, true), PartPose.offsetAndRotation((float)-1.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = body.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(8, 24).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, false), PartPose.offsetAndRotation((float)1.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -5.0f, -2.5f, 5.0f, 5.0f, 5.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition chest2 = chest1.addOrReplaceChild("chest2", CubeListBuilder.create().texOffs(0, 18).addBox(-2.0f, -2.0f, 0.0f, 4.0f, 2.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)0.0f, (float)1.0555751f, (float)0.0f, (float)0.0f));
        PartDefinition monster = chest1.addOrReplaceChild("monster", CubeListBuilder.create().texOffs(15, 0).addBox(-1.0f, -2.0f, 0.0f, 2.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)1.5f, (float)0.1563815f, (float)-0.11728612f, (float)0.0f));
        PartDefinition monsterLeftEye = monster.addOrReplaceChild("monsterLeftEye", CubeListBuilder.create().texOffs(21, 0).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, false), PartPose.offsetAndRotation((float)-0.8f, (float)-1.8f, (float)1.8f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition monsterRightEye = monster.addOrReplaceChild("monsterRightEye", CubeListBuilder.create().texOffs(21, 0).addBox(-0.5f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, true), PartPose.offsetAndRotation((float)0.8f, (float)-1.8f, (float)1.8f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition monsterLeftEar = monster.addOrReplaceChild("monsterLeftEar", CubeListBuilder.create().texOffs(24, 0).addBox(-1.0f, -1.0f, 0.0f, 1.0f, 1.0f, 0.0f, false), PartPose.offsetAndRotation((float)-0.6f, (float)-1.6f, (float)0.3f, (float)-0.312763f, (float)0.07819075f, (float)-0.35185838f));
        PartDefinition monsterRightEar = monster.addOrReplaceChild("monsterRightEar", CubeListBuilder.create().texOffs(24, 0).addBox(0.0f, -1.0f, 0.0f, 1.0f, 1.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.6f, (float)-1.6f, (float)0.3f, (float)-0.312763f, (float)0.07819075f, (float)0.35185838f));
        PartDefinition leftEar = head.addOrReplaceChild("leftEar", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -3.0f, 0.0f, 2.0f, 3.0f, 0.0f, false), PartPose.offsetAndRotation((float)2.0f, (float)-4.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5235988f));
        PartDefinition rightEar = head.addOrReplaceChild("rightEar", CubeListBuilder.create().texOffs(0, 0).addBox(-1.0f, -3.0f, 0.0f, 2.0f, 3.0f, 0.0f, true), PartPose.offsetAndRotation((float)-2.0f, (float)-4.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5235988f));
        PartDefinition nose = head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(18, 8).addBox(-1.0f, 0.0f, -2.0f, 2.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-3.0f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)32, (int)32);
    }

    public void renderToBuffer(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, int pColor) {
        this.body.render(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pColor);
    }

    private float toRad(float deg) {
        return (float)Math.toRadians(deg);
    }

    public void prepareMobModel(GreedyFamiliarEntity pEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTick) {
        this.leftEar.zRot = -pEntity.getEarRotZ(pPartialTick);
        this.rightEar.zRot = pEntity.getEarRotZ(pPartialTick);
        this.leftEar.xRot = pEntity.getEarRotX(pPartialTick);
        this.rightEar.xRot = pEntity.getEarRotX(pPartialTick);
        float ageInTicks = (float)pEntity.tickCount + pPartialTick;
        if (!pEntity.isPartying()) {
            this.chest2.xRot = pEntity.getLidRot(pPartialTick);
            this.monster.y = -0.2f - pEntity.getLidRot(pPartialTick) * 3.0f;
            this.monster.yRot = pEntity.getMonsterRot(pPartialTick);
            this.monster.xRot = 0.0f;
        } else {
            this.chest2.xRot = this.toRad(40.0f);
            this.monster.y = -2.5f;
            this.monster.yRot = 0.0f;
            this.monster.xRot = Mth.cos((float)ageInTicks) * this.toRad(15.0f);
        }
    }

    public void setupAnim(GreedyFamiliarEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.zRot = 0.0f;
        this.rightArm.zRot = 0.0f;
        this.leftArm.zRot = 0.0f;
        if (entityIn.isPartying()) {
            this.rightArm.xRot = Mth.cos((float)(ageInTicks + (float)Math.PI)) * this.toRad(20.0f) + this.toRad(180.0f);
            this.leftArm.xRot = Mth.cos((float)ageInTicks) * this.toRad(20.0f) + this.toRad(180.0f);
            this.rightArm.zRot = -this.toRad(20.0f);
            this.leftArm.zRot = this.toRad(20.0f);
            this.head.zRot = Mth.sin((float)ageInTicks) * this.toRad(20.0f);
            if (entityIn.getVehicle() == null) {
                this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.5f)) * 1.4f * limbSwingAmount;
                this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.5f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            } else {
                this.rightLeg.xRot = -1.5707964f;
                this.leftLeg.xRot = -1.5707964f;
            }
        } else if (entityIn.isSitting() || entityIn.getVehicle() != null) {
            this.rightArm.xRot = 0.0f;
            this.leftArm.xRot = 0.0f;
            this.rightLeg.xRot = -1.5707964f;
            this.leftLeg.xRot = -1.5707964f;
        } else {
            this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.5f + (float)Math.PI)) * limbSwingAmount;
            this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.5f)) * limbSwingAmount;
            this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.5f)) * 1.4f * limbSwingAmount;
            this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.5f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        }
        this.chest1.zRot = Mth.cos((float)(limbSwing * 0.5f + (float)Math.PI)) * limbSwingAmount * 0.2f;
        if (entityIn.getTargetBlock().isPresent()) {
            this.rightArm.xRot = -this.toRad(100.0f) + Mth.cos((float)(limbSwing * 0.5f + (float)Math.PI)) * limbSwingAmount;
        }
    }
}

