/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network.messages;

import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.klikli_dev.occultism.api.common.data.GlobalBlockPos;
import com.klikli_dev.occultism.network.IMessage;
import com.klikli_dev.occultism.registry.OccultismDataComponents;
import com.klikli_dev.occultism.registry.OccultismItems;
import com.klikli_dev.occultism.util.CuriosUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;

public class MessageOpenStorageRemote
implements IMessage {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"open_storage_remote");
    public static final CustomPacketPayload.Type<MessageOpenStorageRemote> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageOpenStorageRemote> STREAM_CODEC = CustomPacketPayload.codec(MessageOpenStorageRemote::encode, MessageOpenStorageRemote::new);

    public MessageOpenStorageRemote(RegistryFriendlyByteBuf buf) {
        this.decode(buf);
    }

    public MessageOpenStorageRemote() {
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        CuriosUtil.SelectedCurio selectedCurio = CuriosUtil.getStorageRemote((Player)player);
        if (selectedCurio != null) {
            if (!selectedCurio.itemStack.has(OccultismDataComponents.LINKED_STORAGE_CONTROLLER)) {
                return;
            }
            GlobalBlockPos storageControllerPos = (GlobalBlockPos)selectedCurio.itemStack.get(OccultismDataComponents.LINKED_STORAGE_CONTROLLER);
            ServerLevel storageControllerWorld = minecraftServer.getLevel(storageControllerPos.getDimensionKey());
            if (storageControllerWorld.getBlockEntity(storageControllerPos.getPos()) instanceof IStorageController) {
                player.openMenu((MenuProvider)OccultismItems.STORAGE_REMOTE.get(), buffer -> buffer.writeVarInt(selectedCurio.selectedSlot));
            }
        }
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
    }

    @Override
    public void decode(RegistryFriendlyByteBuf buf) {
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

