/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.network.messages;

import com.klikli_dev.occultism.api.common.blockentity.IStorageController;
import com.klikli_dev.occultism.api.common.container.IStorageControllerContainer;
import com.klikli_dev.occultism.network.IMessage;
import com.klikli_dev.occultism.network.Networking;
import com.klikli_dev.occultism.network.messages.MessageUpdateLinkedMachines;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class MessageRequestStacks
implements IMessage {
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"occultism", (String)"request_stacks");
    public static final CustomPacketPayload.Type<MessageRequestStacks> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<RegistryFriendlyByteBuf, MessageRequestStacks> STREAM_CODEC = CustomPacketPayload.codec(MessageRequestStacks::encode, MessageRequestStacks::new);

    public MessageRequestStacks() {
    }

    public MessageRequestStacks(RegistryFriendlyByteBuf buf) {
        this.decode(buf);
    }

    @Override
    public void onServerReceived(MinecraftServer minecraftServer, ServerPlayer player) {
        IStorageController storageController;
        if (player.containerMenu instanceof IStorageControllerContainer && (storageController = ((IStorageControllerContainer)player.containerMenu).getStorageController()) != null) {
            Networking.sendTo(player, storageController.getMessageUpdateStacks());
            Networking.sendTo(player, new MessageUpdateLinkedMachines(storageController.getLinkedMachines()));
            player.containerMenu.broadcastChanges();
        }
    }

    @Override
    public void encode(RegistryFriendlyByteBuf buf) {
    }

    @Override
    public void decode(RegistryFriendlyByteBuf buf) {
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

