/*
 * Decompiled with CFR 0.152.
 */
package at.ridgo8.moreoverlays.chunkbounds;

import at.ridgo8.moreoverlays.chunkbounds.ChunkBoundsHandler;
import at.ridgo8.moreoverlays.config.Config;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Camera;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4d;
import org.joml.Vector3f;
import org.joml.Vector4d;

public class ChunkBoundsRenderer {
    private static final ResourceLocation BLANK_TEX = ResourceLocation.fromNamespaceAndPath((String)"moreoverlays", (String)"textures/blank.png");

    public static void renderOverlays(PoseStack matrixstack) {
        int regionZ;
        int regionX;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        Minecraft.getInstance().getTextureManager().bindForSetup(BLANK_TEX);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.lineWidth((float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        if (Minecraft.getInstance().options.graphicsMode().get() != GraphicsStatus.FABULOUS) {
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableCull();
        }
        int h = player.level().getHeight();
        int h0 = (int)player.getY();
        int h1 = Math.min(h, h0 - 16);
        int h2 = Math.min(h, h0 + 16);
        int h3 = Math.min(h1, 0);
        int x0 = player.chunkPosition().x * 16;
        int x1 = x0 + 16;
        int x2 = x0 + 8;
        int z0 = player.chunkPosition().z * 16;
        int z1 = z0 + 16;
        int z2 = z0 + 8;
        int regionY = player.chunkPosition().getWorldPosition().getY() / 32;
        if (player.chunkPosition().x < 0) {
            regionX = (player.chunkPosition().x + 1) / 32;
            --regionX;
        } else {
            regionX = player.chunkPosition().x / 32;
        }
        if (player.chunkPosition().getWorldPosition().getY() < 0) {
            --regionY;
        }
        if (player.chunkPosition().z < 0) {
            regionZ = (player.chunkPosition().z + 1) / 32;
            --regionZ;
        } else {
            regionZ = player.chunkPosition().z / 32;
        }
        int regionBorderX0 = regionX * 32 * 16;
        int regionBorderY0 = regionY * 32 * 16 - 64;
        int regionBorderZ0 = regionZ * 32 * 16;
        int regionBorderX1 = regionBorderX0 + 512;
        int regionBorderY1 = regionBorderY0 + 512 - 128;
        int regionBorderZ1 = regionBorderZ0 + 512;
        int radius = (Integer)Config.chunk_EdgeRadius.get() * 16;
        int renderColorEdge = (Integer)Config.render_chunkEdgeColor.get();
        int renderColorMiddle = (Integer)Config.render_chunkMiddleColor.get();
        int renderColorGrid = (Integer)Config.render_chunkGridColor.get();
        boolean useDebugLines = (Boolean)Config.render_chunkThick.get() == false;
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vector3f look = camera.getLookVector();
        double desiredPixelWidth = 1.5;
        if (!useDebugLines && Minecraft.getInstance().options.graphicsMode().get() != GraphicsStatus.FABULOUS) {
            RenderSystem.disableCull();
        }
        for (int xo = -16 - radius; xo <= radius; xo += 16) {
            for (int yo = -16 - radius; yo <= radius; yo += 16) {
                if (useDebugLines) {
                    ChunkBoundsRenderer.renderEdge(matrixstack, x0 - xo, z0 - yo, h3, h, renderColorEdge);
                    continue;
                }
                ChunkBoundsRenderer.renderEdgeThick(matrixstack, x0 - xo, z0 - yo, h3, h, renderColorEdge, camera, look, desiredPixelWidth);
            }
        }
        if (((Boolean)Config.chunk_ShowMiddle.get()).booleanValue()) {
            if (useDebugLines) {
                ChunkBoundsRenderer.renderEdge(matrixstack, x2, z2, h3, h, renderColorMiddle);
            } else {
                ChunkBoundsRenderer.renderEdgeThick(matrixstack, x2, z2, h3, h, renderColorMiddle, camera, look, desiredPixelWidth);
            }
        }
        if (ChunkBoundsHandler.getMode() == ChunkBoundsHandler.RenderMode.GRID) {
            if (useDebugLines) {
                ChunkBoundsRenderer.renderGrid(matrixstack, x0, h1, (float)z0 - 0.005f, x0, h2, (float)z1 + 0.005f, 1.0, renderColorGrid);
                ChunkBoundsRenderer.renderGrid(matrixstack, x1, h1, (float)z0 - 0.005f, x1, h2, (float)z1 + 0.005f, 1.0, renderColorGrid);
                ChunkBoundsRenderer.renderGrid(matrixstack, (float)x0 - 0.005f, h1, z0, (float)x1 + 0.005f, h2, z0, 1.0, renderColorGrid);
                ChunkBoundsRenderer.renderGrid(matrixstack, (float)x0 - 0.005f, h1, z1, (float)x1 + 0.005f, h2, z1, 1.0, renderColorGrid);
            } else {
                ChunkBoundsRenderer.renderGridThick(matrixstack, x0, h1, (float)z0 - 0.005f, x0, h2, (float)z1 + 0.005f, 1.0, renderColorGrid, camera, look, desiredPixelWidth);
                ChunkBoundsRenderer.renderGridThick(matrixstack, x1, h1, (float)z0 - 0.005f, x1, h2, (float)z1 + 0.005f, 1.0, renderColorGrid, camera, look, desiredPixelWidth);
                ChunkBoundsRenderer.renderGridThick(matrixstack, (float)x0 - 0.005f, h1, z0, (float)x1 + 0.005f, h2, z0, 1.0, renderColorGrid, camera, look, desiredPixelWidth);
                ChunkBoundsRenderer.renderGridThick(matrixstack, (float)x0 - 0.005f, h1, z1, (float)x1 + 0.005f, h2, z1, 1.0, renderColorGrid, camera, look, desiredPixelWidth);
            }
        } else if (ChunkBoundsHandler.getMode() == ChunkBoundsHandler.RenderMode.REGIONS) {
            if (useDebugLines) {
                ChunkBoundsRenderer.renderGrid(matrixstack, (float)regionBorderX0 - 0.005f, (float)regionBorderY0 - 0.005f, (float)regionBorderZ0 - 0.005f, (float)regionBorderX1 + 0.005f, (float)regionBorderY1 + 0.005f, (float)regionBorderZ1 + 0.005f, 16.0, renderColorGrid);
            } else {
                ChunkBoundsRenderer.renderGridThick(matrixstack, (float)regionBorderX0 - 0.005f, (float)regionBorderY0 - 0.005f, (float)regionBorderZ0 - 0.005f, (float)regionBorderX1 + 0.005f, (float)regionBorderY1 + 0.005f, (float)regionBorderZ1 + 0.005f, 16.0, renderColorGrid, camera, look, desiredPixelWidth);
            }
        }
        RenderSystem.depthMask((boolean)true);
        if (Minecraft.getInstance().options.graphicsMode().get() != GraphicsStatus.FABULOUS) {
            RenderSystem.disableCull();
        } else {
            RenderSystem.lineWidth((float)1.0f);
            RenderSystem.enableBlend();
        }
    }

    public static void renderEdge(PoseStack matrixstack, double x, double z, double h3, double h, int color) {
        Matrix4d matrix4d = new Matrix4d();
        matrixstack.last().pose().get(matrix4d);
        Tesselator tess = Tesselator.getInstance();
        Minecraft minecraft = Minecraft.getInstance();
        Camera camera = minecraft.gameRenderer.getMainCamera();
        double cameraX = camera.getPosition().x;
        double cameraY = camera.getPosition().y;
        double cameraZ = camera.getPosition().z;
        x -= cameraX;
        h3 -= cameraY;
        h -= cameraY;
        BufferBuilder bufferBuilder = tess.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        ChunkBoundsRenderer.drawVertex(bufferBuilder, matrix4d, x, h3, z -= cameraZ, r, g, b);
        ChunkBoundsRenderer.drawVertex(bufferBuilder, matrix4d, x, h, z, r, g, b);
        MeshData meshData = bufferBuilder.build();
        if (meshData != null) {
            BufferUploader.drawWithShader((MeshData)meshData);
        }
    }

    public static void renderGrid(PoseStack matrixstack, double x0, double y0, double z0, double x1, double y1, double z1, double step, int color) {
        int i;
        Matrix4d matrix4d = new Matrix4d();
        matrixstack.last().pose().get(matrix4d);
        Tesselator tess = Tesselator.getInstance();
        Minecraft minecraft = Minecraft.getInstance();
        Camera camera = minecraft.gameRenderer.getMainCamera();
        double cameraX = camera.getPosition().x;
        double cameraY = camera.getPosition().y;
        double cameraZ = camera.getPosition().z;
        BufferBuilder renderer = tess.begin(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.POSITION_COLOR);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        double stepSize = Math.max(1.0E-6, step);
        int stepsX = (int)Math.max(0L, Math.round((x1 - x0) / stepSize));
        int stepsY = (int)Math.max(0L, Math.round((y1 - y0) / stepSize));
        int stepsZ = (int)Math.max(0L, Math.round((z1 - z0) / stepSize));
        for (i = 0; i <= stepsX; ++i) {
            double x = x0 + (double)i * stepSize;
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, x - cameraX, y0 - cameraY, z0 - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, x - cameraX, y1 - cameraY, z0 - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, x - cameraX, y0 - cameraY, z1 - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, x - cameraX, y1 - cameraY, z1 - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, x - cameraX, y0 - cameraY, z0 - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, x - cameraX, y0 - cameraY, z1 - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, x - cameraX, y1 - cameraY, z0 - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, x - cameraX, y1 - cameraY, z1 - cameraZ, r, g, b);
        }
        for (i = 0; i <= stepsY; ++i) {
            double y = y0 + (double)i * stepSize;
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, x0 - cameraX, y - cameraY, z0 - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, x1 - cameraX, y - cameraY, z0 - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, x0 - cameraX, y - cameraY, z1 - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, x1 - cameraX, y - cameraY, z1 - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, x0 - cameraX, y - cameraY, z0 - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, x0 - cameraX, y - cameraY, z1 - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, x1 - cameraX, y - cameraY, z0 - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, x1 - cameraX, y - cameraY, z1 - cameraZ, r, g, b);
        }
        for (i = 0; i <= stepsZ; ++i) {
            double z = z0 + (double)i * stepSize;
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, x0 - cameraX, y0 - cameraY, z - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, x1 - cameraX, y0 - cameraY, z - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, x0 - cameraX, y1 - cameraY, z - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, x1 - cameraX, y1 - cameraY, z - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, x0 - cameraX, y0 - cameraY, z - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, x0 - cameraX, y1 - cameraY, z - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, x1 - cameraX, y0 - cameraY, z - cameraZ, r, g, b);
            ChunkBoundsRenderer.drawVertex(renderer, matrix4d, x1 - cameraX, y1 - cameraY, z - cameraZ, r, g, b);
        }
        MeshData meshData = renderer.build();
        if (meshData != null) {
            BufferUploader.drawWithShader((MeshData)meshData);
        }
    }

    private static void drawVertex(BufferBuilder renderer, Matrix4d matrix, double x, double y, double z, float r, float g, float b) {
        Vector4d vector4d = matrix.transform(new Vector4d(x, y, z, 1.0));
        renderer.addVertex((float)vector4d.x(), (float)vector4d.y(), (float)vector4d.z()).setColor(r, g, b, 1.0f);
    }

    private static double computeWorldWidthFromPixels(double desiredPixelWidth, double distanceToCamera) {
        double fovDegrees;
        if (desiredPixelWidth <= 0.0) {
            return 0.0;
        }
        int screenHeight = Math.max(1, Minecraft.getInstance().getWindow().getHeight());
        try {
            Object fovObj = Minecraft.getInstance().options.fov().get();
            fovDegrees = fovObj instanceof Integer ? ((Integer)fovObj).doubleValue() : (fovObj instanceof Double ? (Double)fovObj : 70.0);
        }
        catch (Throwable t) {
            fovDegrees = 70.0;
        }
        double fovRadians = Math.toRadians(fovDegrees);
        double pixelsToWorldFactor = 2.0 * Math.tan(fovRadians / 2.0) / (double)screenHeight;
        double widthWorld = desiredPixelWidth * Math.max(0.0, distanceToCamera) * pixelsToWorldFactor;
        return Math.max(widthWorld, 0.01);
    }

    private static void addThickLine(BufferBuilder renderer, Matrix4d matrix4d, Vector3f cameraLook, double cameraX, double cameraY, double cameraZ, double ax, double ay, double az, double bx, double by, double bz, float r, float g, float b, double desiredPixelWidth) {
        float ux;
        float uy;
        float uz;
        double mx = (ax + bx) * 0.5;
        double my = (ay + by) * 0.5;
        double mz = (az + bz) * 0.5;
        double dx = mx - cameraX;
        double dy = my - cameraY;
        double dz = mz - cameraZ;
        double distance = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double worldWidth = ChunkBoundsRenderer.computeWorldWidthFromPixels(desiredPixelWidth, distance);
        float half = (float)(worldWidth * 0.5);
        float vy = (float)(by - ay);
        float vz = (float)(bz - az);
        float px = vy * cameraLook.z - vz * cameraLook.y;
        float vx = (float)(bx - ax);
        float py = vz * cameraLook.x - vx * cameraLook.z;
        float pz = vx * cameraLook.y - vy * cameraLook.x;
        float plen = (float)Math.sqrt(px * px + py * py + pz * pz);
        if (plen < 1.0E-4f && (plen = (float)Math.sqrt((px = vy * (uz = 0.0f) - vz * (uy = 1.0f)) * px + (py = vz * (ux = 0.0f) - vx * uz) * py + (pz = vx * uy - vy * ux) * pz)) < 1.0E-4f) {
            return;
        }
        float inv = 1.0f / plen;
        double a1x = ax - (double)(px *= inv * half);
        double a1y = ay - (double)(py *= inv * half);
        double a1z = az - (double)(pz *= inv * half);
        double a2x = ax + (double)px;
        double a2y = ay + (double)py;
        double a2z = az + (double)pz;
        double b1x = bx - (double)px;
        double b1y = by - (double)py;
        double b1z = bz - (double)pz;
        double b2x = bx + (double)px;
        double b2y = by + (double)py;
        double b2z = bz + (double)pz;
        ChunkBoundsRenderer.drawVertex(renderer, matrix4d, a1x - cameraX, a1y - cameraY, a1z - cameraZ, r, g, b);
        ChunkBoundsRenderer.drawVertex(renderer, matrix4d, b1x - cameraX, b1y - cameraY, b1z - cameraZ, r, g, b);
        ChunkBoundsRenderer.drawVertex(renderer, matrix4d, b2x - cameraX, b2y - cameraY, b2z - cameraZ, r, g, b);
        ChunkBoundsRenderer.drawVertex(renderer, matrix4d, a1x - cameraX, a1y - cameraY, a1z - cameraZ, r, g, b);
        ChunkBoundsRenderer.drawVertex(renderer, matrix4d, b2x - cameraX, b2y - cameraY, b2z - cameraZ, r, g, b);
        ChunkBoundsRenderer.drawVertex(renderer, matrix4d, a2x - cameraX, a2y - cameraY, a2z - cameraZ, r, g, b);
    }

    private static void renderEdgeThick(PoseStack matrixstack, double x, double z, double h3, double h, int color, Camera camera, Vector3f look, double desiredPixelWidth) {
        Matrix4d matrix4d = new Matrix4d();
        matrixstack.last().pose().get(matrix4d);
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder bufferBuilder = tess.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
        double cameraX = camera.getPosition().x;
        double cameraY = camera.getPosition().y;
        double cameraZ = camera.getPosition().z;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        ChunkBoundsRenderer.addThickLine(bufferBuilder, matrix4d, look, cameraX, cameraY, cameraZ, x, h3, z, x, h, z, r, g, b, desiredPixelWidth);
        MeshData meshData = bufferBuilder.build();
        if (meshData != null) {
            BufferUploader.drawWithShader((MeshData)meshData);
        }
    }

    private static void renderGridThick(PoseStack matrixstack, double x0, double y0, double z0, double x1, double y1, double z1, double step, int color, Camera camera, Vector3f look, double desiredPixelWidth) {
        int i;
        Matrix4d matrix4d = new Matrix4d();
        matrixstack.last().pose().get(matrix4d);
        Tesselator tess = Tesselator.getInstance();
        BufferBuilder renderer = tess.begin(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.POSITION_COLOR);
        double cameraX = camera.getPosition().x;
        double cameraY = camera.getPosition().y;
        double cameraZ = camera.getPosition().z;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        double stepSize = Math.max(1.0E-6, step);
        int stepsX = (int)Math.max(0L, Math.round((x1 - x0) / stepSize));
        int stepsY = (int)Math.max(0L, Math.round((y1 - y0) / stepSize));
        int stepsZ = (int)Math.max(0L, Math.round((z1 - z0) / stepSize));
        for (i = 0; i <= stepsX; ++i) {
            double x = x0 + (double)i * stepSize;
            ChunkBoundsRenderer.addThickLine(renderer, matrix4d, look, cameraX, cameraY, cameraZ, x, y0, z0, x, y1, z0, r, g, b, desiredPixelWidth);
            ChunkBoundsRenderer.addThickLine(renderer, matrix4d, look, cameraX, cameraY, cameraZ, x, y0, z1, x, y1, z1, r, g, b, desiredPixelWidth);
            ChunkBoundsRenderer.addThickLine(renderer, matrix4d, look, cameraX, cameraY, cameraZ, x, y0, z0, x, y0, z1, r, g, b, desiredPixelWidth);
            ChunkBoundsRenderer.addThickLine(renderer, matrix4d, look, cameraX, cameraY, cameraZ, x, y1, z0, x, y1, z1, r, g, b, desiredPixelWidth);
        }
        for (i = 0; i <= stepsY; ++i) {
            double y = y0 + (double)i * stepSize;
            ChunkBoundsRenderer.addThickLine(renderer, matrix4d, look, cameraX, cameraY, cameraZ, x0, y, z0, x1, y, z0, r, g, b, desiredPixelWidth);
            ChunkBoundsRenderer.addThickLine(renderer, matrix4d, look, cameraX, cameraY, cameraZ, x0, y, z1, x1, y, z1, r, g, b, desiredPixelWidth);
            ChunkBoundsRenderer.addThickLine(renderer, matrix4d, look, cameraX, cameraY, cameraZ, x0, y, z0, x0, y, z1, r, g, b, desiredPixelWidth);
            ChunkBoundsRenderer.addThickLine(renderer, matrix4d, look, cameraX, cameraY, cameraZ, x1, y, z0, x1, y, z1, r, g, b, desiredPixelWidth);
        }
        for (i = 0; i <= stepsZ; ++i) {
            double z = z0 + (double)i * stepSize;
            ChunkBoundsRenderer.addThickLine(renderer, matrix4d, look, cameraX, cameraY, cameraZ, x0, y0, z, x1, y0, z, r, g, b, desiredPixelWidth);
            ChunkBoundsRenderer.addThickLine(renderer, matrix4d, look, cameraX, cameraY, cameraZ, x0, y1, z, x1, y1, z, r, g, b, desiredPixelWidth);
            ChunkBoundsRenderer.addThickLine(renderer, matrix4d, look, cameraX, cameraY, cameraZ, x0, y0, z, x0, y1, z, r, g, b, desiredPixelWidth);
            ChunkBoundsRenderer.addThickLine(renderer, matrix4d, look, cameraX, cameraY, cameraZ, x1, y0, z, x1, y1, z, r, g, b, desiredPixelWidth);
        }
        MeshData meshData = renderer.build();
        if (meshData != null) {
            BufferUploader.drawWithShader((MeshData)meshData);
        }
    }
}

