/*
 * Decompiled with CFR 0.152.
 */
package gisellevonbingen.mmp.common.chemical;

import gisellevonbingen.mmp.common.chemical.MMPSlurryBuilder;
import gisellevonbingen.mmp.common.material.MaterialState;
import gisellevonbingen.mmp.common.material.MaterialType;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalBuilder;
import net.minecraft.network.chat.Component;

public class MMPSlurry
extends Chemical {
    public static final String SLURRY = "slurry";
    private final MaterialType materialType;
    private final String slurryType;

    public MMPSlurry(MMPSlurryBuilder builder) {
        super((ChemicalBuilder)builder);
        this.materialType = builder.materialType();
        this.slurryType = builder.slurryType();
    }

    public MaterialType getMaterialType() {
        return this.materialType;
    }

    public String getSlurryType() {
        return this.slurryType;
    }

    public int getTint() {
        return this.getMaterialType().getColor();
    }

    public Component getTextComponent() {
        String descriptionId = this.getTranslationKey();
        String statedDescriptionId = this.getStatedDescriptionId();
        return MaterialState.createTextComponent(descriptionId, statedDescriptionId, this.getMaterialType());
    }

    public String getSlurryName() {
        return MMPSlurry.getSlurryName(this.getSlurryType(), this.getMaterialType());
    }

    public String getStatedDescriptionId() {
        return MMPSlurry.makeDescriptionId(this.getSlurryType());
    }

    public static String makeDescriptionId(String slurryType) {
        return MaterialState.makeDescriptionId(MMPSlurry.getSlurryTypeKey(slurryType));
    }

    public static String getSlurryTypeKey(String slurryType) {
        return slurryType + "_slurry";
    }

    public static String getSlurryName(String slurryType, MaterialType materialType) {
        return MMPSlurry.getSlurryName(slurryType, materialType.getBaseName());
    }

    public static String getSlurryName(String slurryType, String materialType) {
        return slurryType + "_" + materialType;
    }
}

