/*
 * Decompiled with CFR 0.152.
 */
package gisellevonbingen.mmp.common.crafting.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gisellevonbingen.mmp.common.config.MMPConfigs;
import gisellevonbingen.mmp.common.material.MaterialType;
import java.util.Optional;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.conditions.ICondition;

public record CookingDustIntoIngotCondition(String materialType) implements ICondition
{
    public static MapCodec<CookingDustIntoIngotCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.fieldOf("materialType").forGetter(CookingDustIntoIngotCondition::materialType)).apply((Applicative)builder, CookingDustIntoIngotCondition::new));

    public boolean test(ICondition.IContext context) {
        Optional<MaterialType> materialType = MaterialType.find(this.materialType);
        if (!materialType.isPresent()) {
            return true;
        }
        ModConfigSpec.ConfigValue<Boolean> config = MMPConfigs.COMMON.disableDustCookings.get((Object)materialType.get());
        if (config == null) {
            return true;
        }
        Boolean disabled = (Boolean)config.get();
        return disabled == false;
    }

    @Override
    public String toString() {
        return "cooking_dust_into_ingot(\"" + this.materialType + ")";
    }

    public MapCodec<? extends ICondition> codec() {
        return CODEC;
    }
}

