/*
 * Decompiled with CFR 0.152.
 */
package gisellevonbingen.mmp.common.crafting.conditions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gisellevonbingen.mmp.common.config.MMPConfigs;
import gisellevonbingen.mmp.common.material.MaterialType;
import java.util.Optional;
import net.neoforged.neoforge.common.conditions.ICondition;

public record ProcessingLevelCondition(String materialType, int requireLevel) implements ICondition
{
    public static MapCodec<ProcessingLevelCondition> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.STRING.fieldOf("materialType").forGetter(ProcessingLevelCondition::materialType), (App)Codec.INT.fieldOf("requireLevel").forGetter(ProcessingLevelCondition::requireLevel)).apply((Applicative)builder, ProcessingLevelCondition::new));

    public boolean test(ICondition.IContext context) {
        Optional<MaterialType> materialType = MaterialType.find(this.materialType);
        if (!materialType.isPresent()) {
            return true;
        }
        int level = (Integer)MMPConfigs.COMMON.processingLevels.get((Object)materialType.get()).get();
        return level >= this.requireLevel;
    }

    @Override
    public String toString() {
        return "processing_level(\"" + this.materialType + "\" require " + this.requireLevel + ")";
    }

    public MapCodec<? extends ICondition> codec() {
        return CODEC;
    }
}

