/*
 * Decompiled with CFR 0.152.
 */
package gisellevonbingen.mmp.common.material;

import com.google.common.collect.Lists;
import gisellevonbingen.mmp.common.material.MaterialState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum MaterialResultShape {
    DUST(null, Lists.newArrayList((Object[])new MaterialState[]{MaterialState.ORE, MaterialState.CRYSTAL, MaterialState.SHARD, MaterialState.CLUMP, MaterialState.DIRTY_DUST, MaterialState.DUST})),
    INGOT(DUST, Lists.newArrayList((Object[])new MaterialState[]{MaterialState.RAW_STORAGE_BLOCKS, MaterialState.RAW_ITEM, MaterialState.INGOT, MaterialState.NUGGET})),
    GEM(DUST, Lists.newArrayList((Object[])new MaterialState[]{MaterialState.GEM}));

    private MaterialResultShape parent;
    private List<MaterialState> processableStates;

    private MaterialResultShape(MaterialResultShape parent, List<MaterialState> processableStates) {
        this.parent = parent;
        this.processableStates = new ArrayList<MaterialState>();
        if (parent != null) {
            this.processableStates.addAll(parent.getProcessableStates());
        }
        this.processableStates.addAll(processableStates);
        this.ensureStatesValid();
    }

    public boolean isExclusiveStates(List<MaterialState> states, Iterable<MaterialState> exclusiveStates) {
        boolean contains = false;
        for (MaterialState state : exclusiveStates) {
            if (!this.canProcess(state)) continue;
            if (!contains) {
                contains = true;
                continue;
            }
            return false;
        }
        return true;
    }

    public void ensureStatesValid() {
        List<MaterialState> exclusiveStates = Arrays.asList(MaterialState.INGOT, MaterialState.GEM);
        if (!this.isExclusiveStates(this.processableStates, exclusiveStates)) {
            throw new IllegalArgumentException(this.name() + " require exclusiveStates :" + String.valueOf(exclusiveStates));
        }
    }

    public boolean canProcess(MaterialState state) {
        return this.processableStates.contains((Object)state);
    }

    public boolean canProcess(Iterable<MaterialState> states) {
        for (MaterialState state : states) {
            if (this.processableStates.contains((Object)state)) continue;
            return false;
        }
        return true;
    }

    public MaterialResultShape getParent() {
        return this.parent;
    }

    public List<MaterialState> getProcessableStates() {
        return Lists.newArrayList(this.processableStates);
    }
}

