/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.api.datagen.builders;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.favouriteless.modopedia.api.book.BookTexture;
import net.minecraft.resources.ResourceLocation;

public class BookTextureBuilder {
    public static Stage1 of() {
        return new Builder();
    }

    public static class Builder
    implements Stage1,
    Stage2,
    Stage3,
    Stage4,
    Stage5,
    Stage6,
    Stage7,
    Stage8,
    FinalStage {
        private ResourceLocation location;
        private int texWidth;
        private int texHeight;
        private int width;
        private int height;
        private BookTexture.FixedRectangle titleBacker;
        private BookTexture.FixedRectangle left;
        private BookTexture.FixedRectangle right;
        private BookTexture.FixedRectangle back;
        private BookTexture.FixedRectangle refresh;
        private List<BookTexture.Rectangle> pages = new ArrayList<BookTexture.Rectangle>();
        private Map<String, BookTexture.Rectangle> widgets = new HashMap<String, BookTexture.Rectangle>();

        private Builder() {
        }

        @Override
        public Stage2 texture(ResourceLocation location, int texWidth, int texHeight) {
            this.location = location;
            this.texWidth = texWidth;
            this.texHeight = texHeight;
            return this;
        }

        @Override
        public Stage3 sized(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        @Override
        public Stage4 titleBacker(int x, int y, int u, int v, int width, int height) {
            this.titleBacker = BookTexture.FixedRectangle.of(x, y, u, v, width, height);
            return this;
        }

        @Override
        public Stage5 leftButton(int x, int y, int u, int v, int width, int height) {
            this.left = BookTexture.FixedRectangle.of(x, y, u, v, width, height);
            return this;
        }

        @Override
        public Stage6 rightButton(int x, int y, int u, int v, int width, int height) {
            this.right = BookTexture.FixedRectangle.of(x, y, u, v, width, height);
            return this;
        }

        @Override
        public Stage7 backButton(int x, int y, int u, int v, int width, int height) {
            this.back = BookTexture.FixedRectangle.of(x, y, u, v, width, height);
            return this;
        }

        @Override
        public Stage8 refreshButton(int x, int y, int u, int v, int width, int height) {
            this.refresh = BookTexture.FixedRectangle.of(x, y, u, v, width, height);
            return this;
        }

        @Override
        public FinalStage page(int u, int v, int width, int height) {
            this.pages.add(BookTexture.Rectangle.of(u, v, width, height));
            return this;
        }

        @Override
        public FinalStage widget(String name, int u, int v, int width, int height) {
            this.widgets.put(name, BookTexture.Rectangle.of(u, v, width, height));
            return this;
        }

        @Override
        public void build(String id, BiConsumer<String, BookTexture> output) {
            if (this.pages.isEmpty()) {
                throw new IllegalStateException("BookTexture has zero pages:" + id);
            }
            output.accept(id, new BookTexture(this.location, this.width, this.height, this.texWidth, this.texHeight, this.pages, this.titleBacker, this.left, this.right, this.back, this.refresh, this.widgets));
        }
    }

    public static interface FinalStage {
        public FinalStage page(int var1, int var2, int var3, int var4);

        public FinalStage widget(String var1, int var2, int var3, int var4, int var5);

        public void build(String var1, BiConsumer<String, BookTexture> var2);
    }

    public static interface Stage8 {
        public FinalStage page(int var1, int var2, int var3, int var4);
    }

    public static interface Stage7 {
        public Stage8 refreshButton(int var1, int var2, int var3, int var4, int var5, int var6);
    }

    public static interface Stage6 {
        public Stage7 backButton(int var1, int var2, int var3, int var4, int var5, int var6);
    }

    public static interface Stage5 {
        public Stage6 rightButton(int var1, int var2, int var3, int var4, int var5, int var6);
    }

    public static interface Stage4 {
        public Stage5 leftButton(int var1, int var2, int var3, int var4, int var5, int var6);
    }

    public static interface Stage3 {
        public Stage4 titleBacker(int var1, int var2, int var3, int var4, int var5, int var6);
    }

    public static interface Stage2 {
        public Stage3 sized(int var1, int var2);
    }

    public static interface Stage1 {
        public Stage2 texture(ResourceLocation var1, int var2, int var3);
    }
}

