/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.api.datagen.builders.templates.page;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.datagen.builders.page_components.TemplateComponentBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public class EntityPageBuilder
extends TemplateComponentBuilder {
    public static final ResourceLocation ID = Modopedia.id("page/entity");
    private final String text;
    private Either<Integer, String> width;
    private Either<Integer, String> height;
    private Either<Integer, String> textOffset;
    private final Either<EntityType<?>, String> entity;
    private Either<CompoundTag, String> tag;
    private Either<Float, String> offsetY;
    private Either<Float, String> scale;

    private EntityPageBuilder(EntityType<?> type, String text) {
        super(ID);
        this.entity = Either.left(type);
        this.text = text;
    }

    private EntityPageBuilder(String type, String text) {
        super(ID);
        this.entity = Either.right((Object)type);
        this.text = text;
    }

    public static EntityPageBuilder of(EntityType<?> type, String text) {
        return new EntityPageBuilder(type, text);
    }

    public static EntityPageBuilder of(String type, String text) {
        return new EntityPageBuilder(type, text);
    }

    @Override
    public EntityPageBuilder x(int x) {
        return (EntityPageBuilder)super.x(x);
    }

    @Override
    public EntityPageBuilder x(String x) {
        return (EntityPageBuilder)super.x(x);
    }

    @Override
    public EntityPageBuilder y(int y) {
        return (EntityPageBuilder)super.y(y);
    }

    @Override
    public EntityPageBuilder y(String y) {
        return (EntityPageBuilder)super.y(y);
    }

    public EntityPageBuilder tag(CompoundTag tag) {
        this.tag = Either.left((Object)tag);
        return this;
    }

    public EntityPageBuilder tag(String tag) {
        this.tag = Either.right((Object)tag);
        return this;
    }

    public EntityPageBuilder width(int width) {
        this.width = Either.left((Object)width);
        return this;
    }

    public EntityPageBuilder width(String width) {
        this.width = Either.right((Object)width);
        return this;
    }

    public EntityPageBuilder height(int height) {
        this.height = Either.left((Object)height);
        return this;
    }

    public EntityPageBuilder height(String height) {
        this.height = Either.right((Object)height);
        return this;
    }

    public EntityPageBuilder scale(float scale) {
        this.scale = Either.left((Object)Float.valueOf(scale));
        return this;
    }

    public EntityPageBuilder scale(String reference) {
        this.scale = Either.right((Object)reference);
        return this;
    }

    public EntityPageBuilder offsetY(float offsetY) {
        this.offsetY = Either.left((Object)Float.valueOf(offsetY));
        return this;
    }

    public EntityPageBuilder offsetY(String reference) {
        this.offsetY = Either.right((Object)reference);
        return this;
    }

    public EntityPageBuilder textOffset(int textOffset) {
        this.textOffset = Either.left((Object)textOffset);
        return this;
    }

    public EntityPageBuilder textOffset(String textOffset) {
        this.textOffset = Either.right((Object)textOffset);
        return this;
    }

    @Override
    protected void build(JsonObject json, RegistryOps<JsonElement> ops) {
        json.add("entity", this.resolve(this.entity, e -> (JsonElement)ResourceLocation.CODEC.encodeStart((DynamicOps)ops, (Object)BuiltInRegistries.ENTITY_TYPE.getKey(e)).getOrThrow()));
        json.add("text", this.resolveString(this.text));
        if (this.tag != null) {
            json.add("tag", this.resolve(this.tag, t -> (JsonElement)CompoundTag.CODEC.encodeStart((DynamicOps)ops, t).getOrThrow()));
        }
        if (this.offsetY != null) {
            json.add("offset_y", this.resolveNum(this.offsetY));
        }
        if (this.scale != null) {
            json.add("scale", this.resolveNum(this.scale));
        }
        if (this.width != null) {
            json.add("width", this.resolveNum(this.width));
        }
        if (this.height != null) {
            json.add("height", this.resolveNum(this.height));
        }
        if (this.textOffset != null) {
            json.add("text_offset", this.resolveNum(this.textOffset));
        }
    }
}

