/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.api.text;

import net.minecraft.resources.ResourceLocation;

public class FormattedStringBuilder {
    private final StringBuilder builder = new StringBuilder();

    private FormattedStringBuilder() {
    }

    public static FormattedStringBuilder begin() {
        return new FormattedStringBuilder();
    }

    public FormattedStringBuilder then(String text) {
        this.builder.append(text);
        return this;
    }

    public FormattedStringBuilder paragraph() {
        return this.then("\n\n");
    }

    public FormattedStringBuilder paragraph(String text) {
        return this.paragraph().then(text);
    }

    public FormattedStringBuilder linebreak() {
        return this.then("\n");
    }

    public FormattedStringBuilder linebreak(String text) {
        return this.linebreak().then(text);
    }

    public FormattedStringBuilder apply(String tag) {
        return this.then("$(").then(tag).then(")");
    }

    public FormattedStringBuilder apply(String tag, String argument) {
        return this.apply(tag + ":" + argument);
    }

    public FormattedStringBuilder bold() {
        return this.apply("b");
    }

    public FormattedStringBuilder bold(String text) {
        return this.bold().then(text).stopBold();
    }

    public FormattedStringBuilder stopBold() {
        return this.apply("/b");
    }

    public FormattedStringBuilder italic() {
        return this.apply("i");
    }

    public FormattedStringBuilder italic(String text) {
        return this.italic().then(text).stopItalic();
    }

    public FormattedStringBuilder stopItalic() {
        return this.apply("/i");
    }

    public FormattedStringBuilder underline() {
        return this.apply("u");
    }

    public FormattedStringBuilder underline(String text) {
        return this.underline().then(text).stopUnderline();
    }

    public FormattedStringBuilder stopUnderline() {
        return this.apply("/u");
    }

    public FormattedStringBuilder strikethrough() {
        return this.apply("s");
    }

    public FormattedStringBuilder strikethrough(String text) {
        return this.strikethrough().then(text).stopStrikethrough();
    }

    public FormattedStringBuilder stopStrikethrough() {
        return this.apply("/s");
    }

    public FormattedStringBuilder obfuscated() {
        return this.apply("o");
    }

    public FormattedStringBuilder obfuscated(String text) {
        return this.obfuscated().then(text).stopObfuscated();
    }

    public FormattedStringBuilder stopObfuscated() {
        return this.apply("/o");
    }

    public FormattedStringBuilder url(String url, String text) {
        return this.apply("l", url).then(text).apply("/l");
    }

    public FormattedStringBuilder url(String url, String text, int colour) {
        return this.colour(colour).apply("l", url).then(text).apply("/l").stopColour();
    }

    public FormattedStringBuilder command(String command, String text) {
        return this.apply("cmd", command).then(text).apply("/cmd");
    }

    public FormattedStringBuilder clipboard(String copy, String text) {
        return this.apply("clip", copy).then(text).apply("/clip");
    }

    public FormattedStringBuilder tooltip(String tooltip, String text) {
        return this.apply("t", tooltip).then(text).apply("/t");
    }

    public FormattedStringBuilder colour(int colour) {
        return this.apply("c", "#" + Integer.toHexString(colour).toUpperCase());
    }

    public FormattedStringBuilder colour(int colour, String text) {
        return this.colour(colour).then(text).stopColour();
    }

    public FormattedStringBuilder stopColour() {
        return this.apply("/c");
    }

    public FormattedStringBuilder clear() {
        return this.apply("");
    }

    public FormattedStringBuilder font(ResourceLocation font) {
        return this.apply("f:" + String.valueOf(font));
    }

    public FormattedStringBuilder stopFont() {
        return this.apply("/f");
    }

    public FormattedStringBuilder entryLink(String entry, String text) {
        return this.apply("el:" + entry).then(text).apply("/el");
    }

    public FormattedStringBuilder entryLink(String entry, String text, int colour) {
        return this.colour(colour).apply("el:" + entry).then(text).apply("/el").stopColour();
    }

    public FormattedStringBuilder categoryLink(String category, String text) {
        return this.apply("cl:" + category).then(text).apply("/cl");
    }

    public FormattedStringBuilder categoryLink(String category, String text, int colour) {
        return this.colour(colour).apply("cl:" + category).then(text).apply("/cl").stopColour();
    }

    public FormattedStringBuilder boldEntryLink(String entry, String text) {
        return this.bold().entryLink(entry, text).stopBold();
    }

    public FormattedStringBuilder boldEntryLink(String entry, String text, int colour) {
        return this.colour(colour).bold().entryLink(entry, text).stopBold().stopColour();
    }

    public FormattedStringBuilder boldCategoryLink(String entry, String text) {
        return this.bold().categoryLink(entry, text).stopBold();
    }

    public FormattedStringBuilder boldCategoryLink(String entry, String text, int colour) {
        return this.colour(colour).bold().categoryLink(entry, text).stopBold().stopColour();
    }

    public String toString() {
        return this.builder.toString();
    }
}

