/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.book.registries.client;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.book.page_components.ItemDisplay;
import net.favouriteless.modopedia.api.registries.client.ItemDisplayRegistry;
import net.minecraft.resources.ResourceLocation;

public class ItemDisplayRegistryImpl
implements ItemDisplayRegistry {
    public static final ItemDisplayRegistryImpl INSTANCE = new ItemDisplayRegistryImpl();
    private final BiMap<ResourceLocation, MapCodec<? extends ItemDisplay>> codecs = HashBiMap.create();
    private final Codec<MapCodec<? extends ItemDisplay>> typeCodec = ResourceLocation.CODEC.flatXmap(r -> {
        MapCodec<? extends ItemDisplay> c = this.get((ResourceLocation)r);
        return c != null ? DataResult.success(c) : DataResult.error(() -> "Unknown type " + String.valueOf(r));
    }, c -> {
        ResourceLocation location = (ResourceLocation)this.codecs.inverse().get(c);
        return c != null ? DataResult.success((Object)location) : DataResult.error(() -> "Unknown type " + String.valueOf(location));
    });
    private final Codec<ItemDisplay> codec = this.typeCodec.dispatch("type", ItemDisplay::typeCodec, Function.identity());

    private ItemDisplayRegistryImpl() {
    }

    @Override
    public void register(ResourceLocation id, MapCodec<? extends ItemDisplay> codec) {
        if (this.codecs.containsKey((Object)id)) {
            Modopedia.LOG.error("Attempted to register duplicate ItemDisplay type: {}", (Object)id);
        } else {
            this.codecs.put((Object)id, codec);
        }
    }

    @Override
    public MapCodec<? extends ItemDisplay> get(ResourceLocation id) {
        return (MapCodec)this.codecs.get((Object)id);
    }

    @Override
    public Codec<ItemDisplay> codec() {
        return this.codec;
    }
}

