/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.book.registries.common;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.registries.common.BookRegistry;
import net.minecraft.resources.ResourceLocation;

public class BookRegistryImpl
implements BookRegistry {
    public static final BookRegistryImpl INSTANCE = new BookRegistryImpl();
    private final BiMap<ResourceLocation, Book> books = HashBiMap.create();

    private BookRegistryImpl() {
    }

    @Override
    public void register(ResourceLocation id, Book book) {
        if (this.books.containsKey((Object)id)) {
            throw new IllegalArgumentException("Attempted to register a duplicate Modopedia book: " + id.toString());
        }
        this.books.put((Object)id, (Object)book);
    }

    @Override
    public Book getBook(ResourceLocation id) {
        return (Book)this.books.get((Object)id);
    }

    @Override
    public ResourceLocation getId(Book book) {
        return (ResourceLocation)this.books.inverse().get((Object)book);
    }

    @Override
    public Collection<Book> getBooks() {
        return this.books.values();
    }

    @Override
    public Collection<ResourceLocation> getBookIds() {
        return this.books.keySet();
    }

    public void clear() {
        this.books.clear();
    }
}

