/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.book.text;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.favouriteless.modopedia.book.registries.client.TextFormatterRegistryImpl;
import net.favouriteless.modopedia.book.text.Justify;
import net.favouriteless.modopedia.book.text.TextChunk;
import net.favouriteless.modopedia.book.text.TextState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;

public class TextParser {
    private static final String FORMATTER_REGEX = "\\$\\([^$()]*\\)";
    private static final List<String> HYPHEN_EXCLUDE_LANGUAGES = List.of("ja_jp", "ko_kr", "lzh", "zh_cn", "zh_hk", "zh_tw");

    public static List<TextChunk> parse(String rawText, Style baseStyle, int lineWidth, int lineHeight, String language, Justify justify) {
        return TextParser.parse(rawText, baseStyle, lineWidth, lineHeight, !HYPHEN_EXCLUDE_LANGUAGES.contains(language), justify);
    }

    public static List<TextChunk> parse(String rawText, Style baseStyle, int lineWidth, int lineHeight, boolean hyphenate, Justify justify) {
        if (rawText == null || rawText.isBlank()) {
            return List.of();
        }
        String[] split = rawText.splitWithDelimiters(FORMATTER_REGEX, 0);
        TextState styleStack = new TextState(baseStyle);
        ArrayList<Component> paragraph = new ArrayList<Component>();
        boolean lastFormat = false;
        for (String section : split) {
            if (section.isEmpty()) continue;
            if (section.matches(FORMATTER_REGEX)) {
                if (!lastFormat) {
                    styleStack.push();
                }
                TextFormatterRegistryImpl.INSTANCE.tryApply(styleStack, section.substring(2, section.length() - 1));
                lastFormat = true;
                continue;
            }
            paragraph.add((Component)Component.literal((String)section).withStyle(styleStack.peek()));
            lastFormat = false;
        }
        return TextParser.getChunksFrom(paragraph, lineWidth, lineHeight, justify, hyphenate);
    }

    private static List<TextChunk> getChunksFrom(List<Component> sections, int maxWidth, int lineHeight, Justify justify, boolean hyphenate) {
        Font font = Minecraft.getInstance().font;
        ArrayList<TextChunk> out = new ArrayList<TextChunk>();
        ArrayList<TextChunk> line = new ArrayList<TextChunk>();
        int x = 0;
        int y = 0;
        block0: for (int i = 0; i < sections.size(); ++i) {
            Component section = sections.get(i);
            while (section != null) {
                Pair<Component, Component> pair = TextParser.tryWrapComponent(section, maxWidth - x, maxWidth, hyphenate);
                if (pair.getFirst() != null && !((Component)pair.getFirst()).getString().isEmpty()) {
                    int width = font.width((FormattedText)pair.getFirst());
                    line.add(new TextChunk((Component)pair.getFirst(), x, y, width, lineHeight));
                    x += width;
                }
                if (i < sections.size() - 1 && pair.getSecond() == null) continue block0;
                TextParser.tryJustify(line, maxWidth, justify);
                x = 0;
                y += lineHeight;
                section = (Component)pair.getSecond();
                out.addAll(line);
                line.clear();
            }
        }
        for (Component component : sections) {
        }
        out.addAll(line);
        return out;
    }

    private static Pair<Component, Component> tryWrapComponent(Component text, int maxWidth, int lineWidth, boolean hyphenate) {
        Font font = Minecraft.getInstance().font;
        String rawString = text.getString();
        int lineBreak = font.getSplitter().findLineBreak(text.getString(), maxWidth, text.getStyle());
        if (lineBreak == rawString.length()) {
            return Pair.of((Object)text, null);
        }
        int firstSpace = rawString.indexOf(" ");
        if ((firstSpace == -1 || lineBreak < firstSpace) && rawString.charAt(lineBreak) != '\n') {
            if (font.width((FormattedText)text) > lineWidth) {
                if (hyphenate) {
                    return Pair.of((Object)Component.literal((String)(rawString.substring(0, lineBreak - 1) + "-")).withStyle(text.getStyle()), (Object)Component.literal((String)rawString.substring(lineBreak - 1)).withStyle(text.getStyle()));
                }
                return Pair.of((Object)Component.literal((String)rawString.substring(0, lineBreak)).withStyle(text.getStyle()), (Object)Component.literal((String)rawString.substring(lineBreak)).withStyle(text.getStyle()));
            }
            return Pair.of(null, (Object)text);
        }
        return Pair.of((Object)Component.literal((String)rawString.substring(0, lineBreak)).withStyle(text.getStyle()), (Object)Component.literal((String)rawString.substring(lineBreak + 1)).withStyle(text.getStyle()));
    }

    private static int getWidth(List<TextChunk> chunks) {
        if (chunks.isEmpty()) {
            return 0;
        }
        if (chunks.size() == 1) {
            return chunks.getFirst().width;
        }
        TextChunk last = chunks.getLast();
        return last.x + last.width - chunks.getFirst().x;
    }

    private static void tryJustify(List<TextChunk> line, int maxWidth, Justify justify) {
        if (justify == Justify.LEFT) {
            return;
        }
        int width = TextParser.getWidth(line);
        int offset = justify == Justify.RIGHT ? maxWidth - width : maxWidth / 2 - width / 2;
        line.forEach(c -> c.x += offset);
    }
}

