/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.book.variables;

import com.google.common.reflect.TypeToken;
import java.util.List;
import java.util.stream.Stream;
import net.favouriteless.modopedia.api.Variable;

public class ObjectVariable
implements Variable {
    private final Object value;

    private ObjectVariable(Object value) {
        this.value = value;
    }

    @Override
    public <T> T as(TypeToken<T> token) {
        return (T)this.value;
    }

    @Override
    public <T> T as(Class<T> clazz) {
        return clazz.cast(this.value);
    }

    @Override
    public int asInt() {
        return (Integer)this.value;
    }

    @Override
    public long asLong() {
        return ((Integer)this.value).intValue();
    }

    @Override
    public float asFloat() {
        return ((Float)this.value).floatValue();
    }

    @Override
    public double asDouble() {
        return (Double)this.value;
    }

    @Override
    public boolean asBoolean() {
        return (Boolean)this.value;
    }

    @Override
    public String asString() {
        return this.value.toString();
    }

    @Override
    public Stream<Variable> asStream() {
        return ((List)this.value).stream().map(Variable::of);
    }

    public static Variable of(Object object) {
        return new ObjectVariable(object);
    }
}

