/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.multiblock;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.function.Function;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.multiblock.StateMatcher;
import net.favouriteless.modopedia.api.registries.client.StateMatcherRegistry;
import net.minecraft.resources.ResourceLocation;

public class StateMatcherRegistryImpl
implements StateMatcherRegistry {
    public static final StateMatcherRegistryImpl INSTANCE = new StateMatcherRegistryImpl();
    private final BiMap<ResourceLocation, MapCodec<? extends StateMatcher>> codecs = HashBiMap.create();
    private final Codec<MapCodec<? extends StateMatcher>> typeCodec = ResourceLocation.CODEC.flatXmap(r -> {
        MapCodec<? extends StateMatcher> c = this.get((ResourceLocation)r);
        return c != null ? DataResult.success(c) : DataResult.error(() -> "Unknown type " + String.valueOf(r));
    }, c -> {
        ResourceLocation location = (ResourceLocation)this.codecs.inverse().get(c);
        return c != null ? DataResult.success((Object)location) : DataResult.error(() -> "Unknown type " + String.valueOf(location));
    });
    private final Codec<StateMatcher> codec = this.typeCodec.dispatch("type", StateMatcher::typeCodec, Function.identity());

    private StateMatcherRegistryImpl() {
    }

    @Override
    public void register(ResourceLocation id, MapCodec<? extends StateMatcher> codec) {
        if (this.codecs.containsKey((Object)id)) {
            Modopedia.LOG.error("Attempted to register duplicate BlockStateMatcher type: {}", (Object)id);
        } else {
            this.codecs.put((Object)id, codec);
        }
    }

    @Override
    public MapCodec<? extends StateMatcher> get(ResourceLocation id) {
        return (MapCodec)this.codecs.get((Object)id);
    }

    @Override
    public Codec<StateMatcher> codec() {
        return this.codec;
    }
}

