/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.page_components;

import com.google.common.reflect.TypeToken;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.Lookup;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.page_components.BookRenderContext;
import net.favouriteless.modopedia.api.book.page_components.PageComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class ShowcasePageComponent
extends PageComponent {
    public static final ResourceLocation ID = Modopedia.id("showcase");
    protected List<ItemStack> items;
    protected int width;
    protected int height;
    protected float scale;

    @Override
    public void init(Book book, Lookup lookup, Level level) {
        super.init(book, lookup, level);
        this.items = lookup.get("items").as(new TypeToken<List<ItemStack>>(){});
        if (this.items.isEmpty()) {
            throw new IllegalArgumentException("Showcase cannot have zero items in it.");
        }
        this.width = lookup.getOrDefault("width", 100).asInt();
        this.height = lookup.getOrDefault("height", 100).asInt();
        this.scale = lookup.getOrDefault("scale", Float.valueOf(1.0f)).asFloat();
    }

    @Override
    public void render(GuiGraphics graphics, BookRenderContext context, int mouseX, int mouseY, float partialTick) {
        Minecraft mc = Minecraft.getInstance();
        PoseStack pose = graphics.pose();
        ItemRenderer renderer = mc.getItemRenderer();
        MultiBufferSource.BufferSource source = mc.renderBuffers().bufferSource();
        ItemStack item = this.items.get(context.getTicks() / 20 % this.items.size());
        float scale = (float)(-Math.max(this.width, this.height)) * 0.9f * this.scale;
        pose.pushPose();
        pose.translate((float)this.x + (float)this.width / 2.0f, (float)this.y + (float)this.height / 2.0f, 150.0f);
        pose.scale(scale, scale, scale);
        pose.mulPose(Axis.XN.rotationDegrees(15.0f));
        pose.mulPose(Axis.YP.rotationDegrees((float)context.getTicks() + partialTick));
        Lighting.setupForFlatItems();
        renderer.renderStatic(item, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.NO_OVERLAY, pose, (MultiBufferSource)source, (Level)mc.level, 0);
        pose.popPose();
    }
}

