/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.page_components.item_displays;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.book.page_components.BookRenderContext;
import net.favouriteless.modopedia.api.book.page_components.ItemDisplay;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class GridItemDisplay
implements ItemDisplay {
    public static final ResourceLocation ID = Modopedia.id("grid");
    public static final MapCodec<GridItemDisplay> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.lazyInitialized(ItemDisplay::codec).listOf().fieldOf("displays").forGetter(d -> d.displays), (App)Codec.INT.optionalFieldOf("columns", (Object)Integer.MAX_VALUE).forGetter(d -> d.columns), (App)Codec.INT.optionalFieldOf("padding", (Object)16).forGetter(d -> d.padding), (App)Codec.BOOL.optionalFieldOf("centered", (Object)false).forGetter(d -> d.centered)).apply((Applicative)instance, GridItemDisplay::new));
    protected final List<ItemDisplay> displays;
    protected final int columns;
    protected final int padding;
    protected final boolean centered;

    public GridItemDisplay(List<ItemDisplay> displays, int columns, int padding, boolean centered) {
        this.displays = displays;
        this.columns = columns;
        this.padding = padding;
        this.centered = centered;
        if (displays.isEmpty()) {
            throw new IllegalArgumentException("GridItemDisplay cannot have zero child displays.");
        }
    }

    @Override
    public void render(GuiGraphics graphics, BookRenderContext context, int mouseX, int mouseY, String entry) {
        List<ItemDisplay> row;
        int rowCount = 0;
        for (int i = 0; i < this.displays.size(); i += row.size()) {
            row = this.displays.subList(i, Math.min(i + this.columns, this.displays.size()));
            PoseStack pose = graphics.pose();
            int x = this.centered ? -(row.size() * this.padding / 2) : 0;
            int y = rowCount * this.padding;
            for (ItemDisplay display : row) {
                pose.pushPose();
                pose.translate((float)x, (float)y, 0.0f);
                display.render(graphics, context, mouseX - x, mouseY - y, entry);
                pose.popPose();
                x += this.padding;
            }
            ++rowCount;
        }
    }

    @Override
    public MapCodec<? extends ItemDisplay> typeCodec() {
        return CODEC;
    }
}

