/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.screens.books;

import com.mojang.blaze3d.platform.InputConstants;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.ScreenCache;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.BookContent;
import net.favouriteless.modopedia.api.book.BookTexture;
import net.favouriteless.modopedia.api.book.BookType;
import net.favouriteless.modopedia.api.book.page_components.BookRenderContext;
import net.favouriteless.modopedia.api.registries.client.BookTextureRegistry;
import net.favouriteless.modopedia.api.registries.common.BookRegistry;
import net.favouriteless.modopedia.book.StudyManager;
import net.favouriteless.modopedia.book.loading.BookContentLoader;
import net.favouriteless.modopedia.book.registries.client.ItemAssociationRegistry;
import net.favouriteless.modopedia.client.BookOpenHandler;
import net.favouriteless.modopedia.client.init.MKeyMappings;
import net.favouriteless.modopedia.client.screens.widgets.BookImageButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ItemStack;

public abstract class BookScreen<T extends BookType>
extends Screen
implements BookRenderContext {
    protected final ResourceLocation bookId;
    protected final Book book;
    protected final T type;
    protected final String language;
    protected final BookContent.LocalisedBookContent content;
    protected final BookTexture texture;
    protected final BookScreen<?> lastScreen;
    protected int ticks = 0;
    protected int leftPos = 0;
    protected int topPos = 0;

    public BookScreen(Book book, T type, String language, BookContent.LocalisedBookContent content, BookScreen<?> lastScreen, Component title) {
        super(title);
        this.bookId = BookRegistry.get().getId(book);
        this.book = book;
        this.type = type;
        this.language = language;
        this.content = content;
        this.texture = BookTextureRegistry.get().getTexture(book.getTexture());
        this.lastScreen = lastScreen;
        ScreenCache.get().setLastScreen(this.bookId, this.language, this);
    }

    protected void init() {
        super.init();
        if (this.texture == null) {
            Modopedia.LOG.error("Could not find book texture: {}", (Object)this.book.getTexture().toString());
            Minecraft.getInstance().setScreen(null);
            return;
        }
        this.leftPos = (this.width - this.texture.width()) / 2;
        this.topPos = (this.height - this.texture.height()) / 2;
        if (this.minecraft.player == null || !this.minecraft.player.isCreative()) {
            return;
        }
        BookTexture.FixedRectangle w = this.texture.refresh();
        this.addRenderableWidget((GuiEventListener)new BookImageButton(this.texture.location(), this.leftPos + w.x(), this.topPos + w.y(), w.width(), w.height(), w.u(), w.v(), this.texture.texWidth(), this.texture.texHeight(), b -> this.reloadBook(), (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK));
    }

    protected void reloadBook() {
        this.minecraft.setScreen(null);
        BookContentLoader.reload(this.bookId);
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderTransparentBackground(graphics);
        graphics.blit(this.texture.location(), this.leftPos, this.topPos, 0.0f, 0.0f, this.texture.width(), this.texture.height(), this.texture.texWidth(), this.texture.texHeight());
    }

    protected void tryBackButton() {
        if (BookScreen.hasShiftDown() || this.lastScreen == null) {
            if (this.isTopLevel()) {
                return;
            }
            ScreenCache.get().setLastScreen(this.bookId, this.language, null);
            BookOpenHandler.tryOpenBook(this.bookId);
        } else {
            this.minecraft.setScreen(this.lastScreen);
            ScreenCache.get().setLastScreen(this.bookId, this.language, this.lastScreen);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 1) {
            this.tryBackButton();
            return true;
        }
        return false;
    }

    public void tick() {
        ++this.ticks;
    }

    @Override
    public Book getBook() {
        return this.book;
    }

    @Override
    public BookScreen<T> getScreen() {
        return this;
    }

    @Override
    public Style getStyle() {
        return Style.EMPTY.withFont(this.book.getFont()).withColor(this.book.getTextColour());
    }

    @Override
    public Style getHeaderStyle() {
        return Style.EMPTY.withColor(this.book.getHeaderColour());
    }

    @Override
    public BookTexture getBookTexture() {
        return this.texture;
    }

    @Override
    public boolean isHovered(double mouseX, double mouseY, int x, int y, int width, int height) {
        return mouseX > (double)x && mouseY > (double)y && mouseX < (double)(x + width) && mouseY < (double)(y + height);
    }

    @Override
    public int getTicks() {
        return this.ticks;
    }

    @Override
    public void renderItem(GuiGraphics graphics, ItemStack item, int x, int y, int mouseX, int mouseY, String entry) {
        graphics.renderItem(item, x, y);
        graphics.renderItemDecorations(this.font, item, x, y);
        if (!this.isHovered(mouseX, mouseY, x, y, 16, 16)) {
            return;
        }
        graphics.renderTooltip(this.font, item, mouseX, mouseY);
        ItemAssociationRegistry.EntryAssociation association = StudyManager.getAssociation(this.language, item.getItem());
        if (association == null || association.entryId().equals(entry)) {
            return;
        }
        if (!InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)MKeyMappings.KEY_STUDY.key.getValue())) {
            return;
        }
        BookOpenHandler.tryOpenEntry(association.book(), association.entryId());
    }

    protected boolean isTopLevel() {
        return false;
    }
}

