/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.screens.books;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.BookContent;
import net.favouriteless.modopedia.api.book.BookTexture;
import net.favouriteless.modopedia.api.book.BookType;
import net.favouriteless.modopedia.api.book.Entry;
import net.favouriteless.modopedia.api.book.Page;
import net.favouriteless.modopedia.api.book.page_components.PageEventListener;
import net.favouriteless.modopedia.client.screens.books.BookScreen;
import net.favouriteless.modopedia.client.screens.books.MultiPageBookScreen;
import net.favouriteless.modopedia.client.screens.books.book_screen_pages.EntryScreenPage;
import net.favouriteless.modopedia.client.screens.books.book_screen_pages.ScreenPage;
import net.minecraft.network.chat.Component;

public class EntryScreen<T extends BookType>
extends MultiPageBookScreen<T> {
    protected final Entry entry;
    protected final List<PageEventListener> children = new ArrayList<PageEventListener>();
    protected boolean isDragging = false;
    protected PageEventListener focused = null;

    public EntryScreen(Book book, T type, String language, BookContent.LocalisedBookContent content, Entry entry, BookScreen<?> lastScreen) {
        super(book, type, language, content, lastScreen, (Component)Component.literal((String)entry.getTitle()));
        this.entry = entry;
    }

    public EntryScreen(Book book, T type, String language, BookContent.LocalisedBookContent content, Entry entry) {
        this(book, type, language, content, entry, null);
    }

    @Override
    protected void initPages(Consumer<ScreenPage> pageConsumer) {
        for (Page page : this.entry.getPages()) {
            BookTexture.Rectangle details = this.texture.pages().get(this.children.size() % this.texture.pages().size());
            EntryScreenPage screenPage = new EntryScreenPage(this, details, page);
            this.children.add(screenPage);
            pageConsumer.accept(screenPage);
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        int left = this.getLeftPage();
        int max = Math.min(left + this.texture.pages().size(), this.children.size());
        for (PageEventListener child : this.children.subList(left, max)) {
            if (!child.mouseClicked(this, mouseX - (double)this.leftPos, mouseY - (double)this.topPos, button)) continue;
            this.focused = child;
            if (button == 0) {
                this.isDragging = true;
            }
            return true;
        }
        this.focused = null;
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isDragging) {
            this.isDragging = false;
            if (this.focused != null) {
                return this.focused.mouseReleased(this, mouseX, mouseY, button);
            }
        }
        int left = this.getLeftPage();
        int max = Math.min(left + this.texture.pages().size(), this.children.size());
        for (PageEventListener child : this.children.subList(left, max)) {
            if (!child.mouseReleased(this, mouseX - (double)this.leftPos, mouseY - (double)this.topPos, button)) continue;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.focused != null && this.isDragging && button == 0 && this.focused.mouseDragged(this, mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        int left = this.getLeftPage();
        int max = Math.min(left + this.texture.pages().size(), this.children.size());
        for (PageEventListener child : this.children.subList(left, max)) {
            if (!child.mouseScrolled(this, mouseX - (double)this.leftPos, mouseY - (double)this.topPos, scrollX, scrollY)) continue;
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.focused != null && this.focused.keyPressed(this, keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (this.focused != null && this.focused.keyReleased(this, keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (this.focused != null && this.focused.charTyped(this, codePoint, modifiers)) {
            return true;
        }
        return super.charTyped(codePoint, modifiers);
    }
}

