/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.template_processors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.favouriteless.modopedia.Modopedia;
import net.favouriteless.modopedia.api.Lookup;
import net.favouriteless.modopedia.api.Variable;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.BookTexture;
import net.favouriteless.modopedia.api.book.TemplateProcessor;
import net.favouriteless.modopedia.api.book.page_components.ItemDisplay;
import net.favouriteless.modopedia.api.registries.client.BookTextureRegistry;
import net.favouriteless.modopedia.client.page_components.item_displays.CyclingItemDisplay;
import net.favouriteless.modopedia.client.page_components.item_displays.EmptyItemDisplay;
import net.favouriteless.modopedia.client.page_components.item_displays.GridItemDisplay;
import net.favouriteless.modopedia.client.page_components.item_displays.SimpleItemDisplay;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;

public class CraftingRecipeProcessor
implements TemplateProcessor {
    public static final ResourceLocation ID = Modopedia.id("crafting_recipe");
    public static final int GRID_WIDTH = 50;

    @Override
    public void init(Book book, Lookup.MutableLookup lookup, Level level) {
        this.initComponents(book, lookup);
        this.initRecipe(lookup, level);
    }

    protected void initRecipe(Lookup.MutableLookup lookup, Level level) {
        ResourceLocation id = lookup.get("recipe").as(ResourceLocation.class);
        Optional optional = level.getRecipeManager().byKey(id);
        if (optional.isEmpty()) {
            throw new IllegalArgumentException(String.valueOf(id) + " is not a valid recipe.");
        }
        RecipeHolder holder = (RecipeHolder)optional.get();
        Recipe recipe = holder.value();
        if (recipe instanceof ShapelessRecipe) {
            ShapelessRecipe recipe2 = (ShapelessRecipe)recipe;
            displays = recipe2.getIngredients().stream().map(i -> new CyclingItemDisplay(Arrays.asList(i.getItems()))).toList();
            lookup.set("p_inputs", Variable.of(new GridItemDisplay((List<ItemDisplay>)displays, 3, 17, false)));
            lookup.set("p_output", Variable.of(new SimpleItemDisplay(recipe2.getResultItem((HolderLookup.Provider)level.registryAccess()))));
            lookup.set("p_tooltip", Variable.of(List.of(Modopedia.translation("template", "shapeless_recipe"))));
        } else {
            displays = holder.value();
            if (displays instanceof ShapedRecipe) {
                ShapedRecipe recipe3 = (ShapedRecipe)displays;
                NonNullList ingredients = recipe3.getIngredients();
                ArrayList<ItemDisplay> displays = new ArrayList<ItemDisplay>();
                int rows = recipe3.getHeight();
                int columns = recipe3.getWidth();
                for (int y = 0; y < rows; ++y) {
                    for (int x = 0; x < columns; ++x) {
                        ItemStack[] items = ((Ingredient)ingredients.get(x + y * columns)).getItems();
                        displays.add(items.length == 0 ? new EmptyItemDisplay() : new CyclingItemDisplay(Arrays.asList(items)));
                    }
                    for (int i2 = 0; i2 < 3 - columns; ++i2) {
                        displays.add(new EmptyItemDisplay());
                    }
                }
                lookup.set("p_inputs", Variable.of(new GridItemDisplay(displays, 3, 17, false)));
                lookup.set("p_output", Variable.of(new SimpleItemDisplay(recipe3.getResultItem((HolderLookup.Provider)level.registryAccess()))));
                lookup.set("p_tooltip", Variable.of(List.of(Modopedia.translation("template", "shaped_recipe"))));
            } else {
                throw new IllegalArgumentException("CraftingRecipe template must have a valid crafting table recipe.");
            }
        }
    }

    protected void initComponents(Book book, Lookup.MutableLookup lookup) {
        BookTexture tex = BookTextureRegistry.get().getTexture(book.getTexture());
        if (tex == null) {
            throw new IllegalStateException("CraftingRecipe templates require the book to have a valid BookTexture");
        }
        BookTexture.Rectangle page = tex.pages().get(lookup.get("page_num").asInt() % tex.pages().size());
        BookTexture.Rectangle grid = tex.widgets().get("crafting_grid");
        BookTexture.Rectangle arrow = tex.widgets().get("crafting_arrow");
        BookTexture.Rectangle frame = tex.widgets().get("small_frame");
        if (grid == null || arrow == null || frame == null) {
            throw new IllegalStateException("CraftingRecipe templates require the BookTexture to have crafting_grid, crafting_arrow and small_frame widgets");
        }
        int arrowX = 50 + (grid.width() - 50) / 2 + 2;
        int arrowY = 25 - arrow.height() / 2;
        int outputX = arrowX + arrow.width() + 2 + (frame.width() - 16) / 2;
        int offset = (page.width() - (outputX + 16)) / 2;
        lookup.set("p_grid_x", Variable.of(offset));
        lookup.set("p_arrow_x", Variable.of(arrowX + offset));
        lookup.set("p_arrow_y", Variable.of(arrowY));
        lookup.set("p_arrow_width", Variable.of(arrow.width()));
        lookup.set("p_arrow_height", Variable.of(arrow.height()));
        lookup.set("p_output_x", Variable.of(outputX + offset));
    }
}

