/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.common.datagen;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

public abstract class SimpleCodecProvider<T>
implements DataProvider {
    protected final String modId;
    private final Codec<T> codec;
    private final PackOutput.PathProvider pathProvider;
    private final CompletableFuture<HolderLookup.Provider> registries;

    protected SimpleCodecProvider(String modId, PackOutput.PathProvider pathProvider, CompletableFuture<HolderLookup.Provider> registries, Codec<T> codec) {
        this.modId = modId;
        this.pathProvider = pathProvider;
        this.registries = registries;
        this.codec = codec;
    }

    protected abstract void build(HolderLookup.Provider var1, BiConsumer<String, T> var2);

    public CompletableFuture<?> run(CachedOutput output) {
        return this.registries.thenCompose(registries -> this.run(output, (HolderLookup.Provider)registries));
    }

    private CompletableFuture<?> run(CachedOutput output, HolderLookup.Provider registries) {
        HashSet set = Sets.newHashSet();
        ArrayList generated = new ArrayList();
        this.build(registries, (id, t) -> {
            if (!set.add(id)) {
                throw new IllegalStateException("Duplicate " + this.getName() + ": " + id);
            }
            generated.add(DataProvider.saveStable((CachedOutput)output, (HolderLookup.Provider)registries, this.codec, (Object)t, (Path)this.pathProvider.json(ResourceLocation.fromNamespaceAndPath((String)this.modId, (String)id))));
        });
        return CompletableFuture.allOf((CompletableFuture[])generated.toArray(CompletableFuture[]::new));
    }
}

