/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.platform.services;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.favouriteless.modopedia.platform.services.ICommonRegistryHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.registries.DeferredRegister;

public class NeoCommonRegistryHelper
implements ICommonRegistryHelper {
    public static final DeferredRegister<Item> ITEM_REGISTRY = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"modopedia");
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_REGISTRY = DeferredRegister.create((Registry)BuiltInRegistries.DATA_COMPONENT_TYPE, (String)"modopedia");
    public static final DeferredRegister<SoundEvent> SOUND_EVENT_REGISTRY = DeferredRegister.create((Registry)BuiltInRegistries.SOUND_EVENT, (String)"modopedia");
    public static final List<PreparableReloadListener> RELOAD_LISTENERS = new ArrayList<PreparableReloadListener>();

    @Override
    public <T extends Item> Supplier<T> registerItem(String name, Supplier<T> entry) {
        return ITEM_REGISTRY.register(name, entry);
    }

    @Override
    public <T extends DataComponentType<C>, C> Supplier<T> registerDataComponent(String name, Supplier<T> entry) {
        return DATA_COMPONENT_REGISTRY.register(name, entry);
    }

    @Override
    public <T extends SoundEvent> Holder<T> registerSound(String name, Supplier<T> entry) {
        return SOUND_EVENT_REGISTRY.register(name, entry);
    }

    @Override
    public PreparableReloadListener registerReloadListener(ResourceLocation id, PreparableReloadListener loader) {
        RELOAD_LISTENERS.add(loader);
        return loader;
    }
}

