/*
 * Decompiled with CFR 0.152.
 */
package reliquary.block;

import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import reliquary.block.tile.ApothecaryMortarBlockEntity;
import reliquary.init.ModBlocks;
import reliquary.init.ModItems;
import reliquary.item.ICreativeTabItemGenerator;
import reliquary.reference.Config;
import reliquary.util.InventoryHelper;
import reliquary.util.WorldHelper;

public class ApothecaryMortarBlock
extends Block
implements EntityBlock,
ICreativeTabItemGenerator {
    public static final DirectionProperty FACING = DirectionProperty.create((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    private static final VoxelShape MORTAR_SHAPE = Stream.of(Block.box((double)6.0, (double)1.5, (double)6.0, (double)10.0, (double)2.5, (double)10.0), Block.box((double)5.0, (double)2.5, (double)5.0, (double)11.0, (double)3.5, (double)11.0), Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)1.5, (double)11.0), Block.box((double)4.0, (double)3.5, (double)5.0, (double)5.0, (double)6.5, (double)11.0), Block.box((double)11.0, (double)3.5, (double)5.0, (double)12.0, (double)6.5, (double)11.0), Block.box((double)5.0, (double)3.5, (double)11.0, (double)11.0, (double)6.5, (double)12.0), Block.box((double)5.0, (double)3.5, (double)4.0, (double)11.0, (double)6.5, (double)5.0)).reduce((v1, v2) -> Shapes.join((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.OR)).get();

    public ApothecaryMortarBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).strength(1.5f, 2.0f));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public void addCreativeTabItems(Consumer<ItemStack> itemConsumer) {
        if (Boolean.TRUE.equals(Config.COMMON.disable.disablePotions.get())) {
            return;
        }
        itemConsumer.accept(new ItemStack((ItemLike)this));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return MORTAR_SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ApothecaryMortarBlockEntity(pos, state);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return level.getBlockEntity(pos, ModBlocks.APOTHECARY_MORTAR_TILE_TYPE.get()).map(mortar -> {
            if (player.isCrouching()) {
                InventoryHelper.executeOnItemHandlerAt(level, pos, state, mortar, itemHandler -> InventoryHelper.tryRemovingLastStack(itemHandler, level, mortar.getBlockPos()));
                return InteractionResult.SUCCESS;
            }
            if (mortar.usePestle(level)) {
                level.playSound(null, pos, this.soundType.getStepSound(), SoundSource.BLOCKS, (this.soundType.getVolume() + 1.0f) / 2.0f, this.soundType.getPitch() * 0.8f);
                player.swing(InteractionHand.MAIN_HAND);
                return InteractionResult.CONSUME;
            }
            return InteractionResult.FAIL;
        }).orElse(InteractionResult.FAIL);
    }

    protected ItemInteractionResult useItemOn(ItemStack heldItem, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        return level.getBlockEntity(pos, ModBlocks.APOTHECARY_MORTAR_TILE_TYPE.get()).map(mortar -> {
            if (mortar.isInCooldown(level) && heldItem.getItem() == ModItems.POTION_ESSENCE.get()) {
                return ItemInteractionResult.FAIL;
            }
            ItemStack stackToAdd = heldItem.copy();
            stackToAdd.setCount(1);
            boolean putItemInSlot = InventoryHelper.executeOnItemHandlerAt(level, pos, state, mortar, itemHandler -> {
                if (InventoryHelper.insertIntoInventory(stackToAdd, itemHandler) == 1) {
                    heldItem.shrink(1);
                    return true;
                }
                return false;
            }, false);
            if (!putItemInSlot) {
                if (mortar.usePestle(level)) {
                    level.playSound(null, pos, this.soundType.getStepSound(), SoundSource.BLOCKS, (this.soundType.getVolume() + 1.0f) / 2.0f, this.soundType.getPitch() * 0.8f);
                    return ItemInteractionResult.CONSUME;
                }
                return ItemInteractionResult.FAIL;
            }
            mortar.setChanged();
            return ItemInteractionResult.SUCCESS;
        }).orElse(ItemInteractionResult.FAIL);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getPlayer() == null) {
            return this.defaultBlockState();
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getPlayer().getDirection());
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        WorldHelper.getBlockEntity((BlockGetter)level, pos, ApothecaryMortarBlockEntity.class).ifPresent(mortar -> mortar.dropItems(level));
        super.onRemove(state, level, pos, newState, isMoving);
    }
}

