/*
 * Decompiled with CFR 0.152.
 */
package reliquary.block.tile;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import reliquary.block.ApothecaryCauldronBlock;
import reliquary.block.tile.BlockEntityBase;
import reliquary.client.init.ModParticles;
import reliquary.compat.jade.provider.IJadeDataChangeIndicator;
import reliquary.init.ModBlocks;
import reliquary.init.ModItems;
import reliquary.item.PotionEssenceItem;
import reliquary.reference.Config;
import reliquary.util.InventoryHelper;
import reliquary.util.potions.PotionHelper;

public class ApothecaryCauldronBlockEntity
extends BlockEntityBase
implements IJadeDataChangeIndicator {
    private int redstoneCount = 0;
    private PotionContents potionContents = PotionContents.EMPTY;
    private int glowstoneCount = 0;
    private boolean hasGunpowder = false;
    private boolean hasNetherwart = false;
    private boolean hasDragonBreath = false;
    private int cookTime = 0;
    private int liquidLevel = 0;
    private boolean dataChanged = true;

    public ApothecaryCauldronBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.APOTHECARY_CAULDRON_TILE_TYPE.get(), pos, state);
    }

    public void serverTick(Level level, BlockPos pos) {
        if (this.getHeatSources().contains(level.getBlockState(pos.offset(0, -1, 0)).getBlock()) && this.getLiquidLevel() > 0) {
            if (this.potionContents.hasEffects() && this.hasNetherwart && this.cookTime < this.getTotalCookTime()) {
                ++this.cookTime;
            }
            if (level.isClientSide) {
                this.spawnParticles(level, pos);
            }
        }
    }

    private void spawnParticles(Level level, BlockPos pos) {
        for (int particleCount = 0; particleCount <= 2; ++particleCount) {
            this.spawnBoilingParticles(level, pos);
        }
        if (this.hasDragonBreath) {
            this.spawnDragonBreathParticles(level, pos);
        } else if (this.hasGunpowder) {
            this.spawnGunpowderParticles(level, pos);
        }
        if (this.glowstoneCount > 0) {
            this.spawnGlowstoneParticles(level, pos);
        }
        if (this.hasNetherwart) {
            this.spawnNetherwartParticles(level, pos);
            if (this.finishedCooking()) {
                this.spawnFinishedParticles(level, pos);
            }
        }
        if (this.redstoneCount > 0) {
            this.spawnRedstoneParticles(level, pos);
        }
    }

    private void spawnBoilingParticles(Level level, BlockPos pos) {
        if (level.random.nextInt(this.getTotalCookTime() * this.getTotalCookTime()) > this.cookTime * this.cookTime) {
            return;
        }
        float xOffset = (level.random.nextFloat() - 0.5f) / 1.33f;
        float zOffset = (level.random.nextFloat() - 0.5f) / 1.33f;
        int color = this.potionContents.getColor();
        float red = (float)(color >> 16 & 0xFF) / 256.0f;
        float green = (float)(color >> 8 & 0xFF) / 256.0f;
        float blue = (float)(color & 0xFF) / 256.0f;
        level.addParticle((ParticleOptions)ColorParticleOption.create(ModParticles.CAULDRON_BUBBLE.get(), (float)red, (float)green, (float)blue), (double)pos.getX() + 0.5 + (double)xOffset, (double)pos.getY() + 0.01 + (double)this.getRenderLiquidLevel(), (double)pos.getZ() + 0.5 + (double)zOffset, 0.0, 0.0, 0.0);
        if (level.random.nextInt(6) == 0) {
            level.addParticle((ParticleOptions)ColorParticleOption.create(ModParticles.CAULDRON_STEAM.get(), (float)red, (float)green, (float)blue), (double)pos.getX() + 0.5 + (double)xOffset, (double)pos.getY() + 0.01 + (double)this.getRenderLiquidLevel(), (double)pos.getZ() + 0.5 + (double)zOffset, 0.0, 0.05 + (double)(0.02f * this.getRenderLiquidLevel()), 0.0);
        }
    }

    private float getRenderLiquidLevel() {
        int j = Mth.clamp((int)this.getLiquidLevel(), (int)0, (int)3);
        return (float)(6 + 3 * j) / 16.0f;
    }

    private void spawnGunpowderParticles(Level level, BlockPos pos) {
        if (level.random.nextInt(8) > 0) {
            return;
        }
        float xOffset = (level.random.nextFloat() - 0.5f) / 1.66f;
        float zOffset = (level.random.nextFloat() - 0.5f) / 1.66f;
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5 + (double)xOffset, (double)((float)pos.getY() + this.getRenderLiquidLevel()), (double)pos.getZ() + 0.5 + (double)zOffset, 0.0, 0.1, 0.0);
    }

    private void spawnDragonBreathParticles(Level level, BlockPos pos) {
        if (level.random.nextInt(8) > 0) {
            return;
        }
        float xOffset = (level.random.nextFloat() - 0.5f) / 1.66f;
        float zOffset = (level.random.nextFloat() - 0.5f) / 1.66f;
        level.addParticle((ParticleOptions)ParticleTypes.DRAGON_BREATH, (double)pos.getX() + 0.5 + (double)xOffset, (double)((float)pos.getY() + this.getRenderLiquidLevel()), (double)pos.getZ() + 0.5 + (double)zOffset, 0.0, 0.1, 0.0);
    }

    private void spawnGlowstoneParticles(Level level, BlockPos pos) {
        if (level.random.nextInt(8) > 0) {
            return;
        }
        float gauss = 0.5f + level.random.nextFloat() / 2.0f;
        float xOffset = (level.random.nextFloat() - 0.5f) / 1.66f;
        float zOffset = (level.random.nextFloat() - 0.5f) / 1.66f;
        level.addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)gauss, (float)gauss, (float)0.0f), (double)pos.getX() + 0.5 + (double)xOffset, (double)((float)pos.getY() + this.getRenderLiquidLevel()), (double)pos.getZ() + 0.5 + (double)zOffset, 0.0, 0.0, 0.0);
    }

    private void spawnNetherwartParticles(Level level, BlockPos pos) {
        if (level.random.nextInt(8) > 0) {
            return;
        }
        float gauss = 0.5f + level.random.nextFloat() / 2.0f;
        float xOffset = (level.random.nextFloat() - 0.5f) / 1.66f;
        float zOffset = (level.random.nextFloat() - 0.5f) / 1.66f;
        level.addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)gauss, (float)0.0f, (float)gauss), (double)pos.getX() + 0.5 + (double)xOffset, (double)((float)pos.getY() + this.getRenderLiquidLevel()), (double)pos.getZ() + 0.5 + (double)zOffset, 0.0, 0.0, 0.0);
    }

    private void spawnRedstoneParticles(Level level, BlockPos pos) {
        if (level.random.nextInt(10) / this.redstoneCount > 0) {
            return;
        }
        float xOffset = (level.random.nextFloat() - 0.5f) / 1.66f;
        float zOffset = (level.random.nextFloat() - 0.5f) / 1.66f;
        level.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, (double)pos.getX() + 0.5 + (double)xOffset, (double)((float)pos.getY() + this.getRenderLiquidLevel()), (double)pos.getZ() + 0.5 + (double)zOffset, 1.0, 0.0, 0.0);
    }

    private void spawnFinishedParticles(Level level, BlockPos pos) {
        if (level.random.nextInt(8) > 0) {
            return;
        }
        float xOffset = (level.random.nextFloat() - 0.5f) / 1.66f;
        float zOffset = (level.random.nextFloat() - 0.5f) / 1.66f;
        level.addParticle((ParticleOptions)ParticleTypes.WITCH, (double)pos.getX() + 0.5 + (double)xOffset, (double)((float)pos.getY() + this.getRenderLiquidLevel()), (double)pos.getZ() + 0.5 + (double)zOffset, 0.0, 0.0, 0.0);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.setLiquidLevel(tag.getShort("liquidLevel"));
        this.glowstoneCount = tag.getInt("glowstoneCount");
        this.hasNetherwart = tag.getBoolean("hasNetherwart");
        this.hasGunpowder = tag.getBoolean("hasGunpowder");
        this.hasDragonBreath = tag.getBoolean("hasDragonBreath");
        this.redstoneCount = tag.getInt("redstoneCount");
        this.cookTime = tag.getInt("cookTime");
        this.potionContents = PotionHelper.getPotionContentsFromCompoundTag(tag);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider registries) {
        super.saveAdditional(compound, registries);
        compound.putInt("liquidLevel", this.getLiquidLevel());
        compound.putInt("cookTime", this.cookTime);
        compound.putInt("redstoneCount", this.redstoneCount);
        compound.putInt("glowstoneCount", this.glowstoneCount);
        compound.putBoolean("hasGunpowder", this.hasGunpowder);
        compound.putBoolean("hasDragonBreath", this.hasDragonBreath);
        compound.putBoolean("hasNetherwart", this.hasNetherwart);
        PotionHelper.addPotionContentsToCompoundTag(compound, this.potionContents);
    }

    private boolean finishedCooking() {
        return this.hasNetherwart && this.potionContents.hasEffects() && this.cookTime >= this.getTotalCookTime() && (!this.hasDragonBreath || this.hasGunpowder);
    }

    private ItemStack removeContainedPotion(Level level, BlockPos pos) {
        ItemStack potion = this.hasDragonBreath ? new ItemStack((ItemLike)ModItems.LINGERING_POTION.get()) : (this.hasGunpowder ? new ItemStack((ItemLike)ModItems.SPLASH_POTION.get()) : new ItemStack((ItemLike)ModItems.POTION.get()));
        potion.set(DataComponents.POTION_CONTENTS, (Object)PotionHelper.augmentPotionContents(this.potionContents, this.redstoneCount, this.glowstoneCount));
        this.setLiquidLevel(this.getLiquidLevel() - 1);
        if (this.getLiquidLevel() <= 0) {
            this.clearAllFields(level, pos);
        }
        return potion;
    }

    private void clearAllFields(Level level, BlockPos pos) {
        this.cookTime = 0;
        this.glowstoneCount = 0;
        this.hasGunpowder = false;
        this.hasNetherwart = false;
        this.redstoneCount = 0;
        this.potionContents = PotionContents.EMPTY;
        this.dataChanged = true;
        this.hasDragonBreath = false;
        level.sendBlockUpdated(pos, this.getBlockState(), this.getBlockState(), 3);
    }

    private boolean isItemValidForInput(ItemStack stack) {
        if (stack.getItem() instanceof PotionEssenceItem && !this.potionContents.hasEffects()) {
            return true;
        }
        if (!this.potionContents.hasEffects()) {
            return false;
        }
        if (stack.getItem() == Items.GUNPOWDER && !this.hasGunpowder) {
            return true;
        }
        if (stack.getItem() == Items.GLOWSTONE_DUST && this.glowstoneCount < this.getGlowstoneAmpLimit()) {
            return true;
        }
        if (stack.getItem() == Items.REDSTONE && this.redstoneCount < this.getRedstoneAmpLimit()) {
            return true;
        }
        if (stack.getItem() == Items.NETHER_WART && !this.hasNetherwart) {
            return true;
        }
        return stack.getItem() == Items.DRAGON_BREATH && !this.hasDragonBreath;
    }

    private void addItem(ItemStack stack, Level level, BlockPos pos) {
        if (stack.getItem() instanceof PotionEssenceItem) {
            this.potionContents = (PotionContents)stack.get(DataComponents.POTION_CONTENTS);
        } else if (stack.getItem() == Items.GUNPOWDER) {
            this.hasGunpowder = true;
        } else if (stack.getItem() == Items.GLOWSTONE_DUST) {
            ++this.glowstoneCount;
        } else if (stack.getItem() == Items.REDSTONE) {
            ++this.redstoneCount;
        } else if (stack.getItem() == Items.NETHER_WART) {
            this.hasNetherwart = true;
        } else if (stack.getItem() == Items.DRAGON_BREATH) {
            this.hasDragonBreath = true;
        }
        level.sendBlockUpdated(pos, this.getBlockState(), this.getBlockState(), 3);
    }

    private int getGlowstoneAmpLimit() {
        return (Integer)Config.COMMON.blocks.apothecaryCauldron.glowstoneLimit.get();
    }

    private int getRedstoneAmpLimit() {
        return (Integer)Config.COMMON.blocks.apothecaryCauldron.redstoneLimit.get();
    }

    private Set<Block> getHeatSources() {
        HashSet<Block> heatSources = new HashSet<Block>();
        ((List)Config.COMMON.blocks.apothecaryCauldron.heatSources.get()).forEach(blockName -> heatSources.add((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)blockName))));
        heatSources.add(Blocks.LAVA);
        heatSources.add(Blocks.FIRE);
        heatSources.add(Blocks.SOUL_FIRE);
        heatSources.add(Blocks.CAMPFIRE);
        heatSources.add(Blocks.SOUL_CAMPFIRE);
        return heatSources;
    }

    private int getTotalCookTime() {
        return (Integer)Config.COMMON.blocks.apothecaryCauldron.cookTime.get();
    }

    public PotionContents getPotionContents() {
        return this.potionContents;
    }

    public boolean hasNetherwart() {
        return this.hasNetherwart;
    }

    public boolean hasGunpowder() {
        return this.hasGunpowder;
    }

    public boolean hasDragonBreath() {
        return this.hasDragonBreath;
    }

    public int getRedstoneCount() {
        return this.redstoneCount;
    }

    public int getGlowstoneCount() {
        return this.glowstoneCount;
    }

    public void handleCollidingEntity(Level level, BlockPos pos, Entity collidingEntity) {
        int l = this.getLiquidLevel();
        float f = (float)pos.getY() + (6.0f + (float)(3 * l)) / 16.0f;
        if (collidingEntity.getBoundingBox().minY <= (double)f) {
            LivingEntity livingEntity;
            if (collidingEntity.isOnFire() && l > 0) {
                collidingEntity.clearFire();
            }
            if (collidingEntity instanceof LivingEntity && !this.addEffectsToEntity(level, collidingEntity, livingEntity = (LivingEntity)collidingEntity)) {
                return;
            }
            if (collidingEntity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)collidingEntity;
                this.pickupItem(level, pos, itemEntity);
            }
        }
    }

    private void pickupItem(Level level, BlockPos pos, ItemEntity itemEntity) {
        ItemStack item = itemEntity.getItem();
        while (this.isItemValidForInput(item)) {
            this.addItem(item, level, pos);
            item.shrink(1);
        }
    }

    private boolean addEffectsToEntity(Level level, Entity collidingEntity, LivingEntity livingEntity) {
        if (!this.potionContents.hasEffects()) {
            return false;
        }
        if (this.finishedCooking()) {
            for (MobEffectInstance effect : this.potionContents.getAllEffects()) {
                MobEffect potion = (MobEffect)effect.getEffect().value();
                if (potion.isInstantenous() && level.getGameTime() % 20L != 0L) continue;
                MobEffectInstance reducedEffect = new MobEffectInstance(effect.getEffect(), potion.isInstantenous() ? 1 : effect.getDuration() / 20, Math.max(0, effect.getAmplifier() - 1));
                livingEntity.addEffect(reducedEffect);
            }
        }
        if (this.cookTime > 0 && level.getGameTime() % 10L == 0L) {
            collidingEntity.hurt(level.damageSources().inFire(), 1.0f);
        }
        return true;
    }

    public int getColorMultiplier() {
        return this.potionContents.getColor();
    }

    public int getLiquidLevel() {
        return this.liquidLevel;
    }

    public void fillWithRain() {
        if (this.getLiquidLevel() < 3 && !this.finishedCooking()) {
            this.setLiquidLevel(this.getLiquidLevel() + 1);
        }
    }

    public ItemInteractionResult handleBlockActivation(Level level, Player player, InteractionHand hand, BlockPos pos) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (itemStack.isEmpty()) {
            return ItemInteractionResult.CONSUME;
        }
        if (this.getLiquidLevel() < 3 && !this.finishedCooking()) {
            return this.fillWithWater(player, hand, itemStack);
        }
        if (itemStack.getItem() == ModItems.EMPTY_POTION_VIAL.get() && this.finishedCooking() && this.getLiquidLevel() > 0) {
            if (this.fillVial(level, player, hand, itemStack, pos)) {
                return ItemInteractionResult.SUCCESS;
            }
        } else if (this.getLiquidLevel() == 3 && this.isItemValidForInput(itemStack)) {
            return this.addIngredient(level, player, itemStack, pos);
        }
        return ItemInteractionResult.CONSUME;
    }

    private ItemInteractionResult addIngredient(Level level, Player player, ItemStack itemStack, BlockPos pos) {
        this.addItem(itemStack, level, pos);
        if (itemStack.getItem() == Items.DRAGON_BREATH && InventoryHelper.tryToAddToInventory(new ItemStack((ItemLike)Items.GLASS_BOTTLE), InventoryHelper.getMainInventoryItemHandlerFrom(player), 1) != 1) {
            Containers.dropItemStack((Level)level, (double)((float)this.worldPosition.getX() + 0.5f), (double)((float)this.worldPosition.getY() + 1.5f), (double)((float)this.worldPosition.getZ() + 0.5f), (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE));
        }
        itemStack.shrink(1);
        return ItemInteractionResult.SUCCESS;
    }

    private boolean fillVial(Level level, Player player, InteractionHand hand, ItemStack itemStack, BlockPos pos) {
        if (this.finishedCooking() && this.hasNetherwart && this.potionContents.hasEffects() && this.getLiquidLevel() > 0) {
            ItemStack potion = this.removeContainedPotion(level, pos);
            itemStack.shrink(1);
            if (itemStack.getCount() <= 0) {
                player.setItemInHand(hand, potion);
            } else if (!player.getInventory().add(potion)) {
                level.addFreshEntity((Entity)new ItemEntity(level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.5, (double)this.worldPosition.getZ() + 0.5, potion));
            }
            return true;
        }
        return false;
    }

    private ItemInteractionResult fillWithWater(Player player, InteractionHand hand, ItemStack itemStack) {
        if (itemStack.getItem() == Items.WATER_BUCKET) {
            if (!player.isCreative()) {
                player.setItemInHand(hand, new ItemStack((ItemLike)Items.BUCKET));
            }
        } else {
            IFluidHandlerItem fluidHandlerCapability = (IFluidHandlerItem)itemStack.getCapability(Capabilities.FluidHandler.ITEM);
            if (fluidHandlerCapability == null || !this.drainWater(player, fluidHandlerCapability).booleanValue()) {
                return ItemInteractionResult.CONSUME;
            }
        }
        this.setLiquidLevel(3);
        player.level().playSound(null, this.worldPosition, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.cookTime = 0;
        return ItemInteractionResult.SUCCESS;
    }

    private Boolean drainWater(Player player, IFluidHandlerItem fh) {
        FluidStack waterStack = new FluidStack((Fluid)Fluids.WATER, 1000);
        if (!waterStack.equals(fh.drain(waterStack, IFluidHandler.FluidAction.SIMULATE))) {
            return false;
        }
        if (!player.isCreative()) {
            fh.drain(waterStack, IFluidHandler.FluidAction.EXECUTE);
        }
        return true;
    }

    private void setLiquidLevel(int liquidLevel) {
        this.liquidLevel = liquidLevel;
        if (this.level != null) {
            BlockState blockState = this.getBlockState();
            blockState = (BlockState)blockState.setValue((Property)ApothecaryCauldronBlock.LEVEL, (Comparable)Integer.valueOf(liquidLevel));
            this.level.setBlockAndUpdate(this.getBlockPos(), blockState);
            this.level.updateNeighbourForOutputSignal(this.worldPosition, (Block)ModBlocks.APOTHECARY_CAULDRON.get());
        }
    }

    @Override
    public boolean getDataChanged() {
        boolean ret = this.dataChanged;
        this.dataChanged = false;
        return ret;
    }

    @Override
    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider registries) {
        super.onDataPacket(net, packet, registries);
        this.dataChanged = true;
    }
}

