/*
 * Decompiled with CFR 0.152.
 */
package reliquary.block.tile;

import java.util.Optional;
import java.util.function.Function;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import reliquary.block.tile.PedestalBlockEntity;

public class PedestalFluidHandler
implements IFluidHandler {
    private final PedestalBlockEntity pedestal;

    PedestalFluidHandler(PedestalBlockEntity pedestal) {
        this.pedestal = pedestal;
    }

    public int getTanks() {
        return this.getFluidHandlerValue(IFluidHandler::getTanks).orElse(0);
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return this.getFluidHandlerValue(fh -> fh.getFluidInTank(tank)).orElse(FluidStack.EMPTY);
    }

    public int getTankCapacity(int tank) {
        return this.getFluidHandlerValue(fh -> fh.getTankCapacity(tank)).orElse(0);
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.getFluidHandlerValue(fh -> fh.isFluidValid(tank, stack)).orElse(false);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.getFluidHandlerValue(fh -> this.executeAndUpdateItem((IFluidHandler)fh, f -> f.fill(resource, action))).orElse(0);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.getFluidHandlerValue(fh -> this.executeAndUpdateItem((IFluidHandler)fh, f -> f.drain(resource, action))).orElse(FluidStack.EMPTY);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.getFluidHandlerValue(fh -> this.executeAndUpdateItem((IFluidHandler)fh, f -> f.drain(maxDrain, action))).orElse(FluidStack.EMPTY);
    }

    private <T> T executeAndUpdateItem(IFluidHandler fh, Function<IFluidHandler, T> execute) {
        IFluidHandlerItem fhi;
        T ret = execute.apply(fh);
        if (fh instanceof IFluidHandlerItem && (fhi = (IFluidHandlerItem)fh).getContainer() != this.pedestal.getItem()) {
            this.pedestal.setItem(fhi.getContainer());
        }
        return ret;
    }

    private <T> Optional<T> getFluidHandlerValue(Function<IFluidHandler, T> mapValue) {
        ItemStack fluidContainer = this.pedestal.getFluidContainer();
        if (fluidContainer.isEmpty()) {
            return Optional.empty();
        }
        IFluidHandler fh = (IFluidHandler)fluidContainer.getCapability(Capabilities.FluidHandler.ITEM);
        return Optional.ofNullable(mapValue.apply(fh));
    }
}

