/*
 * Decompiled with CFR 0.152.
 */
package reliquary.crafting;

import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.level.ItemLike;
import reliquary.init.ModItems;
import reliquary.item.MobCharmFragmentItem;

public class FragmentRecipeHelper {
    public static final Item FALL_BACK_SPAWN_EGG = Items.CHICKEN_SPAWN_EGG;

    private FragmentRecipeHelper() {
    }

    public static boolean hasOnlyOneFragmentType(CraftingInput inv) {
        ResourceLocation regName = null;
        for (int slot = 0; slot < inv.size(); ++slot) {
            ItemStack slotStack = inv.getItem(slot);
            if (slotStack.getItem() != ModItems.MOB_CHARM_FRAGMENT.get()) continue;
            if (regName == null) {
                regName = MobCharmFragmentItem.getEntityRegistryName(slotStack);
                continue;
            }
            if (regName.equals((Object)MobCharmFragmentItem.getEntityRegistryName(slotStack))) continue;
            return false;
        }
        return true;
    }

    public static Optional<ResourceLocation> getRegistryName(CraftingInput inv) {
        for (int slot = 0; slot < inv.size(); ++slot) {
            ItemStack slotStack = inv.getItem(slot);
            if (slotStack.getItem() != ModItems.MOB_CHARM_FRAGMENT.get()) continue;
            return Optional.of(MobCharmFragmentItem.getEntityRegistryName(slotStack));
        }
        return Optional.empty();
    }

    public static ItemStack getSpawnEggStack(ResourceLocation regName) {
        SpawnEggItem spawnEggItem = SpawnEggItem.byId((EntityType)((EntityType)BuiltInRegistries.ENTITY_TYPE.get(regName)));
        return new ItemStack((ItemLike)(spawnEggItem == null ? FALL_BACK_SPAWN_EGG : spawnEggItem));
    }
}

