/*
 * Decompiled with CFR 0.152.
 */
package reliquary.entity.shot;

import net.minecraft.core.Direction;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import reliquary.entity.ConcussiveExplosion;
import reliquary.entity.shot.ShotBase;
import reliquary.init.ModEntities;
import reliquary.reference.ClientReference;

public class ConcussiveShot
extends ShotBase {
    public ConcussiveShot(EntityType<ConcussiveShot> entityType, Level level) {
        super(entityType, level);
    }

    public ConcussiveShot(Level level, Player player, InteractionHand hand) {
        super(ModEntities.CONCUSSIVE_SHOT.get(), level, player, hand);
    }

    @Override
    int getRicochetMax() {
        return 0;
    }

    @Override
    int getDamageOfShot(LivingEntity mop) {
        return 8 + this.d6();
    }

    @Override
    void doFlightEffects() {
        if (this.ticksInAir % 3 == 0) {
            this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.SMOKE);
        }
    }

    @Override
    void spawnHitParticles(int i) {
    }

    @Override
    void doFiringEffects() {
        this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (float)0.5f, (float)0.5f, (float)0.5f), this.getX() + this.smallGauss(0.1), this.getY() + this.smallGauss(0.1), this.getZ() + this.smallGauss(0.1), 0.0, 0.0, 0.0);
        this.spawnMotionBasedParticle((ParticleOptions)ParticleTypes.FLAME);
    }

    @Override
    protected void onImpact(LivingEntity livingEntity) {
        if (this.level().isClientSide) {
            return;
        }
        this.getShooterPlayer().ifPresent(player -> ConcussiveExplosion.customConcussiveExplosion((Entity)this, player, this.position(), 1.5f, true));
        super.onImpact(livingEntity);
    }

    @Override
    void doBurstEffect(Direction sideHit) {
        if (this.level().isClientSide) {
            return;
        }
        this.getShooterPlayer().ifPresent(player -> ConcussiveExplosion.customConcussiveExplosion((Entity)this, player, this.position(), 1.5f, true));
        this.discard();
    }

    @Override
    public ResourceLocation getShotTexture() {
        return ClientReference.CONCUSSIVE;
    }
}

