/*
 * Decompiled with CFR 0.152.
 */
package reliquary.item.util.fluid;

import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import reliquary.init.ModItems;

public class FluidHandlerEmperorChalice
implements IFluidHandlerItem {
    public static final FluidStack BUCKET_OF_WATER = new FluidStack((Fluid)Fluids.WATER, 1000);
    private final ItemStack chalice;

    public FluidHandlerEmperorChalice(ItemStack chalice) {
        this.chalice = chalice;
    }

    public ItemStack getContainer() {
        return this.chalice;
    }

    public int getTanks() {
        return 1;
    }

    public FluidStack getFluidInTank(int tank) {
        return BUCKET_OF_WATER;
    }

    public int getTankCapacity(int tank) {
        return 1000;
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return stack.getFluid() == Fluids.WATER;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (!ModItems.EMPEROR_CHALICE.get().isEnabled(this.chalice) || resource.isEmpty() || resource.getFluid() != Fluids.WATER) {
            return 0;
        }
        return resource.getAmount();
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (ModItems.EMPEROR_CHALICE.get().isEnabled(this.chalice) || resource.isEmpty() || resource.getFluid() != Fluids.WATER) {
            return FluidStack.EMPTY;
        }
        return new FluidStack((Fluid)Fluids.WATER, Math.min(1000, resource.getAmount()));
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (ModItems.EMPEROR_CHALICE.get().isEnabled(this.chalice)) {
            return FluidStack.EMPTY;
        }
        return new FluidStack((Fluid)Fluids.WATER, Math.min(1000, maxDrain));
    }
}

