/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.registry.builders;

import com.devdyna.justdynathings.Constants;
import com.devdyna.justdynathings.config.common;
import com.devdyna.justdynathings.registry.types.zComponents;
import com.direwolf20.justdirethings.common.entities.TimeWandEntity;
import com.direwolf20.justdirethings.common.items.TimeWand;
import com.direwolf20.justdirethings.common.items.interfaces.FluidContainingItem;
import com.direwolf20.justdirethings.common.items.interfaces.PoweredItem;
import com.direwolf20.justdirethings.setup.Config;
import com.direwolf20.justdirethings.util.MiscTools;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.common.util.FakePlayer;

public class AdvancedTimeWand
extends TimeWand {
    public int getMaxEnergy() {
        return (Integer)common.ADVANCED_TIME_WAND_FE_CAPACITY.get();
    }

    public int getMaxMB() {
        return (Integer)common.ADVANCED_TIME_WAND_MB_CAPACITY.get();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack item = player.getItemInHand(hand);
        BlockHitResult hitResult = AdvancedTimeWand.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (!((Boolean)common.ADVANCED_TIME_WAND_FAKE_PLAYER_ALLOWED.get()).booleanValue() && player instanceof FakePlayer) {
            return InteractionResultHolder.fail((Object)item);
        }
        if (!item.has(zComponents.MODE)) {
            this.resetComponent(level, player, hand);
        }
        if (!MODES.list.contains(item.get(zComponents.MODE))) {
            this.resetComponent(level, player, hand);
        }
        switch (hitResult.getType()) {
            case MISS: {
                if (this.changeMode(level, player, hand, item)) {
                    return InteractionResultHolder.success((Object)item);
                }
            }
            case BLOCK: {
                if (!this.spawnEntity(level, player, hitResult.getBlockPos(), item)) break;
                return InteractionResultHolder.success((Object)item);
            }
        }
        return super.use(level, player, hand);
    }

    protected boolean changeMode(Level level, Player player, InteractionHand hand, ItemStack item) {
        if (!player.isCrouching()) {
            return false;
        }
        String mode = (String)item.get(zComponents.MODE);
        player.swing(hand);
        String resultMode = mode;
        resultMode = mode.equals(MODES.MAX) ? MODES.NORMAL : MODES.list.get(MODES.list.indexOf(resultMode) + 1);
        item.set(zComponents.MODE, (Object)resultMode);
        this.message(player, "tip." + resultMode);
        return true;
    }

    public boolean spawnEntity(Level level, Player player, BlockPos pos, ItemStack item) {
        if (level.isClientSide) {
            return false;
        }
        if (!MiscTools.isValidTickAccelBlock((ServerLevel)((ServerLevel)level), (BlockState)level.getBlockState(pos), (BlockEntity)level.getBlockEntity(pos))) {
            return false;
        }
        int max = Config.logBase2((int)((Integer)common.ADVANCED_TIME_WAND_MAX_MULTIPLIER.get()));
        int power = MODES.values.get(MODES.list.indexOf(item.get(zComponents.MODE)));
        if (power > max) {
            this.message(player, "mode.disabled");
            return false;
        }
        int setRate = power;
        Optional entity = level.getEntitiesOfClass(TimeWandEntity.class, new AABB(pos)).stream().findFirst();
        if (entity.isPresent()) {
            TimeWandEntity timeWandEntity = (TimeWandEntity)entity.get();
            int speed = timeWandEntity.getTickSpeed();
            if (speed >= max) {
                return false;
            }
            setRate = Math.min(speed + power, max);
            int accelRate = (int)TimeWandEntity.calculateAccelRate((int)setRate);
            int mb = AdvancedTimeWand.calculateFluidCost((Player)player, (int)accelRate);
            int fe = AdvancedTimeWand.calculateFECost((Player)player, (int)accelRate);
            if (this.hasResources(player, item, fe, mb)) {
                timeWandEntity.setTickSpeed(setRate);
                timeWandEntity.addTime((timeWandEntity.getTotalTime() - timeWandEntity.getRemainingTime()) / 2);
                this.clickSuccess(item, mb, fe, level, pos, setRate);
                return true;
            }
        } else {
            int accelRate = (int)TimeWandEntity.calculateAccelRate((int)setRate);
            if (accelRate > (Integer)common.ADVANCED_TIME_WAND_MAX_MULTIPLIER.get()) {
                this.message(player, "mode.disabled");
                return false;
            }
            int mb = AdvancedTimeWand.calculateFluidCost((Player)player, (int)accelRate);
            int fe = AdvancedTimeWand.calculateFECost((Player)player, (int)accelRate);
            if (this.hasResources(player, item, fe, mb)) {
                TimeWandEntity timeWandEntity = new TimeWandEntity(level, pos);
                timeWandEntity.setTickSpeed(setRate);
                level.addFreshEntity((Entity)timeWandEntity);
                this.clickSuccess(item, mb, fe, level, pos, setRate);
                return true;
            }
        }
        return false;
    }

    protected void message(Player player, String type) {
        player.displayClientMessage((Component)Component.translatable((String)("justdynathings." + Constants.Wands.AdvancedTime + "." + type)), true);
    }

    public static void playTimeWandSound(Level serverLevel, BlockPos pos, int setRate) {
        float pitch = switch (setRate) {
            case 1 -> 0.707107f;
            case 2 -> 0.793701f;
            case 3 -> 0.890899f;
            case 4 -> 0.943874f;
            case 5 -> 1.059463f;
            case 6 -> 1.189207f;
            case 7 -> 1.33484f;
            case 8 -> 1.414214f;
            case 9 -> 1.587401f;
            case 10 -> 1.781797f;
            case 11 -> 1.887749f;
            default -> 1.0f;
        };
        serverLevel.playSound(null, pos, (SoundEvent)SoundEvents.NOTE_BLOCK_IRON_XYLOPHONE.value(), SoundSource.PLAYERS, 1.0f, pitch);
    }

    protected void resetComponent(Level level, Player player, InteractionHand hand) {
        ItemStack item = player.getItemInHand(hand);
        player.swing(hand);
        item.set(zComponents.MODE, (Object)MODES.NORMAL);
        level.playSound(null, player.getOnPos(), SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.BLOCKS, (float)(level.random.nextInt(10) + 1) * 0.01f, (float)level.random.nextInt(50) + 0.01f);
        this.message(player, "mode.reset");
    }

    protected void clickSuccess(ItemStack item, int mb, int fe, Level level, BlockPos pos, int rate) {
        FluidContainingItem.consumeFluid((ItemStack)item, (int)mb);
        PoweredItem.consumeEnergy((ItemStack)item, (int)fe);
        AdvancedTimeWand.playTimeWandSound(level, pos, rate);
    }

    public void appendHoverText(ItemStack i, Item.TooltipContext context, List<Component> t, TooltipFlag flagIn) {
        t.add((Component)Component.translatable((String)("justdynathings." + Constants.Wands.AdvancedTime)));
        if (i.get(zComponents.MODE) != null) {
            int value = MODES.list.indexOf(i.get(zComponents.MODE));
            MutableComponent normal = Component.translatable((String)("justdynathings." + Constants.Wands.AdvancedTime + ".mode.normal")).withStyle(value == 0 ? ChatFormatting.GREEN : ChatFormatting.GRAY);
            MutableComponent x2 = Component.translatable((String)("justdynathings." + Constants.Wands.AdvancedTime + ".mode.x2")).withStyle(value == 1 ? ChatFormatting.GREEN : ChatFormatting.GRAY);
            MutableComponent x4 = Component.translatable((String)("justdynathings." + Constants.Wands.AdvancedTime + ".mode.x4")).withStyle(value == 2 ? ChatFormatting.GREEN : ChatFormatting.GRAY);
            MutableComponent max = Component.translatable((String)("justdynathings." + Constants.Wands.AdvancedTime + ".mode.max")).withStyle(value == 3 ? ChatFormatting.GREEN : ChatFormatting.GRAY);
            MutableComponent start = Component.literal((String)"[ ").withStyle(ChatFormatting.GRAY);
            MutableComponent mid = Component.literal((String)" | ").withStyle(ChatFormatting.GRAY);
            MutableComponent end = Component.literal((String)" ]").withStyle(ChatFormatting.GRAY);
            t.add((Component)start.append((Component)normal).append((Component)mid).append((Component)x2).append((Component)mid).append((Component)x4).append((Component)mid).append((Component)max).append((Component)end));
        }
        super.appendHoverText(i, context, t, flagIn);
    }

    class MODES {
        public static String NORMAL = "normal";
        public static String X2 = "x2";
        public static String X4 = "x4";
        public static String MAX = "max";
        public static List<String> list = List.of(NORMAL, X2, X4, MAX);
        public static List<Integer> values = List.of((Integer)common.ADVANCED_TIME_WAND_NORMAL_MODE.get(), (Integer)common.ADVANCED_TIME_WAND_X2_MODE.get(), (Integer)common.ADVANCED_TIME_WAND_X4_MODE.get(), (Integer)common.ADVANCED_TIME_WAND_MAX_MODE.get());

        MODES(AdvancedTimeWand this$0) {
        }
    }
}

