/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.registry.builders;

import com.devdyna.justdynathings.Constants;
import com.devdyna.justdynathings.utils.DataGenUtil;
import com.direwolf20.justdirethings.common.entities.TimeWandEntity;
import com.direwolf20.justdirethings.common.items.datacomponents.JustDireDataComponents;
import com.direwolf20.justdirethings.common.items.interfaces.Ability;
import com.direwolf20.justdirethings.common.items.interfaces.AbilityMethods;
import com.direwolf20.justdirethings.common.items.interfaces.AbilityParams;
import com.direwolf20.justdirethings.common.items.interfaces.BaseToggleableTool;
import com.direwolf20.justdirethings.common.items.interfaces.LeftClickableTool;
import com.direwolf20.justdirethings.setup.Config;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class StupefyWand
extends BaseToggleableTool
implements LeftClickableTool {
    protected final EnumSet<Ability> abilities = EnumSet.noneOf(Ability.class);
    protected final Map<Ability, AbilityParams> abilityParams = new EnumMap<Ability, AbilityParams>(Ability.class);

    public StupefyWand() {
        super(new Item.Properties().attributes(ItemAttributeModifiers.builder().add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(DataGenUtil.getResource("entity_interaction_range"), 4.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()).component((Supplier)JustDireDataComponents.STUPEFY_TARGETS, new ArrayList()).stacksTo(1).durability(2048));
        this.registerAbility(Ability.STUPEFY, new AbilityParams(1, 1, 1, 1, 200, 50));
    }

    public void inventoryTick(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull Entity entity, int itemSlot, boolean isSelected) {
        if (!this.getCooldownAbilities().isEmpty() && entity instanceof Player) {
            Player player = (Player)entity;
            this.armorTick(level, player, itemStack);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        Optional entity;
        BlockHitResult hitResult = StupefyWand.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        BlockPos pos = hitResult.getBlockPos();
        ItemStack item = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            this.openSettings(player);
            return InteractionResultHolder.success((Object)item);
        }
        if (hitResult.getType() == HitResult.Type.MISS && !level.isClientSide && AbilityMethods.stupefy((Level)level, (Player)player, (ItemStack)item)) {
            return InteractionResultHolder.success((Object)item);
        }
        if (hitResult.getType() == HitResult.Type.BLOCK && (entity = level.getEntitiesOfClass(TimeWandEntity.class, new AABB(pos)).stream().findFirst()).isPresent()) {
            ((TimeWandEntity)entity.get()).setRemainingTime(0);
            return InteractionResultHolder.success((Object)item);
        }
        if (hitResult.getType() == HitResult.Type.ENTITY) {
            // empty if block
        }
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack i, Item.TooltipContext c, List<Component> t, TooltipFlag f) {
        t.add((Component)Component.translatable((String)("justdynathings." + Constants.Wands.Stupefy)));
        super.appendHoverText(i, c, t, f);
    }

    public EnumSet<Ability> getAllAbilities() {
        return this.abilities;
    }

    public EnumSet<Ability> getAbilities() {
        return this.abilities.stream().filter(ability -> (Boolean)((ModConfigSpec.BooleanValue)Config.AVAILABLE_ABILITY_MAP.get(ability)).get()).collect(Collectors.toCollection(() -> EnumSet.noneOf(Ability.class)));
    }

    public Map<Ability, AbilityParams> getAbilityParamsMap() {
        return this.abilityParams;
    }
}

