/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.justdynathings.utils;

import com.devdyna.justdynathings.utils.IDUtil;
import com.direwolf20.justdirethings.client.particles.glitterparticle.GlitterParticleData;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;

public class LevelUtil {
    public static boolean isDimension(Level level, ResourceKey<Level> dim) {
        return level.dimension().equals(dim);
    }

    public static boolean isBiome(Level level, BlockPos pos, String modid, String biome) {
        return level.getBiome(pos).is(ResourceLocation.fromNamespaceAndPath((String)modid, (String)biome));
    }

    public static boolean isBiome(Level level, BlockPos pos, TagKey<Biome> biome) {
        return level.getBiome(pos).is(biome);
    }

    public static void SimplePlaceBlock(Level level, BlockPos pos, Block block) {
        level.setBlock(pos, block.defaultBlockState(), 32);
    }

    public static int ValidFaces(BlockPos pos, Level level, TagKey<Block> tag) {
        BlockPos[] dir = new BlockPos[]{pos.above(), pos.below(), pos.north(), pos.south(), pos.east(), pos.west()};
        int value = 0;
        for (BlockPos face : dir) {
            value += level.getBlockState(face).is(tag) ? 1 : 0;
        }
        return value;
    }

    public static List<Holder<Block>> ResourceByTag(TagKey<Block> tag) {
        return BuiltInRegistries.BLOCK.getOrCreateTag(tag).stream().toList();
    }

    public static Block ResourceByTag(TagKey<Block> tag, int index) {
        return (Block)LevelUtil.ResourceByTag(tag).get(index).value();
    }

    public static int getSizeTag(TagKey<Block> tag) {
        return LevelUtil.ResourceByTag(tag).size() - 1;
    }

    public static void popItemFromPos(Level level, double x, double y, double z, ItemStack itemStack) {
        ItemEntity itementity = new ItemEntity(level, x, y, z, itemStack);
        level.addFreshEntity((Entity)itementity);
    }

    public static void popItemFromPos(Level level, int x, int y, int z, ItemStack itemStack) {
        LevelUtil.popItemFromPos(level, (double)x, (double)y, (double)z, itemStack);
    }

    public static void popItemFromPos(LevelAccessor level, double x, double y, double z, ItemStack itemStack) {
        LevelUtil.popItemFromPos((Level)level, x, y, z, itemStack);
    }

    public static List<ItemStack> getItemStackFromLootTable(LevelAccessor level, String raw_ore_name, float luck) {
        LootParams.Builder builder = new LootParams.Builder((ServerLevel)level);
        LootParams params = builder.create(LootContextParamSets.EMPTY);
        builder.withLuck(luck);
        LootTable lootTable = level.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)IDUtil.getModName(raw_ore_name), (String)("blocks/" + raw_ore_name.substring(raw_ore_name.lastIndexOf(46) + 1)))));
        return lootTable.getRandomItems(params);
    }

    public static List<ItemStack> getItemStackFromLootTable(LevelAccessor level, String raw_ore_name) {
        return LevelUtil.getItemStackFromLootTable(level, raw_ore_name, 1.0f);
    }

    public static List<ItemStack> getItemStackFromLootTable(LevelAccessor level, String raw_ore_name, Player player) {
        return LevelUtil.getItemStackFromLootTable(level, raw_ore_name, player.getLuck());
    }

    public static List<ItemStack> getItemStackFromLootTable(LevelAccessor level, BlockState state) {
        return LevelUtil.getItemStackFromLootTable(level, state.getBlock().getDescriptionId(), 1.0f);
    }

    public static List<ItemStack> getItemStackFromLootTable(ServerLevel level, String ModName, String resourcelocation) {
        LootTable lootTable = level.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)ModName, (String)resourcelocation)));
        return lootTable.getRandomItems(new LootParams.Builder(level).create(LootContextParamSets.EMPTY));
    }

    public static int getRandomValue(int max, Level l) {
        if (max <= 0) {
            return 1;
        }
        return l.random.nextInt(max) + 1;
    }

    public static int getRandomValue(int min, int max, Level l) {
        return LevelUtil.getRandomValue(max, l) + min;
    }

    public static boolean chance(int v, Level l) {
        if (v == 0) {
            return false;
        }
        return LevelUtil.getRandomValue(100, l) <= v;
    }

    public static boolean rnd50(Level l) {
        return LevelUtil.chance(50, l);
    }

    public static void SpawnGlitterParticle(float red, float green, float blue, BlockPos pos, Level level, float[] speed, int N) {
        for (int i = 0; i < N; ++i) {
            GlitterParticleData data = GlitterParticleData.playerparticle((String)"glitter", (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5), (float)(0.05f + -0.025f * level.random.nextFloat()), (float)red, (float)green, (float)blue, (float)0.5f, (float)120.0f, (boolean)false);
            level.addParticle((ParticleOptions)data, (double)pos.getX() + level.random.nextDouble() * 0.5 + (level.random.nextBoolean() ? -0.5 : 1.0), (double)pos.getY() + level.random.nextDouble() * 0.5 + (level.random.nextBoolean() ? -0.5 : 1.0), (double)pos.getZ() + level.random.nextDouble() * 0.5 + (level.random.nextBoolean() ? -0.5 : 1.0), (double)speed[0], (double)speed[1], (double)speed[2]);
        }
    }

    public static BlockPos RandomPos3D(Level l, BlockPos pos) {
        BlockPos[] a = new BlockPos[]{pos.above(), pos.below(), pos.north(), pos.south(), pos.east(), pos.west()};
        BlockPos s = a[l.random.nextInt(6)];
        if (s.equals((Object)pos.above()) || s.equals((Object)pos.below())) {
            BlockPos[] b = new BlockPos[]{s, s.equals((Object)pos.above()) ? pos.below() : pos.above(), s.north(), s.south(), s.east(), s.west()};
            return b[l.random.nextInt(6)];
        }
        return s;
    }

    public static void popItemFromPos(Level level, BlockPos pos, ItemStack itemStack) {
        LevelUtil.popItemFromPos(level, pos.getX(), pos.getY(), pos.getZ(), itemStack);
    }

    public static int predicateNeighborMatch(Level level, BlockPos pos, Predicate<Block> predicate) {
        int counter = 0;
        for (Direction dir : Direction.values()) {
            Block block = level.getBlockState(pos.relative(dir)).getBlock();
            if (!predicate.test(block)) continue;
            ++counter;
        }
        return counter;
    }

    public static int directionedNeighborMatch(Level level, BlockPos pos, BiPredicate<Block, Direction> predicate) {
        int counter = 0;
        for (Direction dir : Direction.values()) {
            Block block = level.getBlockState(pos.relative(dir)).getBlock();
            if (!predicate.test(block, dir)) continue;
            ++counter;
        }
        return counter;
    }
}

