/*
 * Decompiled with CFR 0.152.
 */
package reliquary.compat.curios;

import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.items.ItemStackHandler;
import reliquary.compat.curios.CuriosBaubleItemWrapper;
import reliquary.compat.curios.CuriosCharmInventoryHandler;
import reliquary.compat.curios.CuriosCompatClient;
import reliquary.init.ModItems;
import reliquary.util.PlayerInventoryProvider;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosCompat {
    private static final EmptyCuriosHandler EMPTY_HANDLER = new EmptyCuriosHandler();

    private void addPlayerInventoryHandlers() {
        PlayerInventoryProvider.get().addPlayerInventoryHandler("curios", () -> CuriosApi.getSlots((boolean)false).keySet(), (player, identifier) -> CuriosCompat.getFromCuriosSlotStackHandler((LivingEntity)player, identifier, ICurioStacksHandler::getSlots, 0), (player, identifier, slot) -> CuriosCompat.getFromCuriosSlotStackHandler((LivingEntity)player, identifier, sh -> sh.getStacks().getStackInSlot(slot), ItemStack.EMPTY), (player, identifier, slot, stack) -> CuriosApi.getCuriosInventory((LivingEntity)player).flatMap(h -> h.getStacksHandler(identifier)).ifPresent(sh -> sh.getStacks().setStackInSlot(slot, stack)), true);
    }

    public static <T> T getFromCuriosSlotStackHandler(LivingEntity livingEntity, String identifier, Function<ICurioStacksHandler, T> getFromHandler, T defaultValue) {
        return (T)CuriosApi.getCuriosInventory((LivingEntity)livingEntity).map(h -> h.getStacksHandler(identifier).map(getFromHandler).orElse(defaultValue)).orElse(defaultValue);
    }

    public CuriosCompat(IEventBus modBus) {
        modBus.addListener(this::setup);
        modBus.addListener(this::onRegisterCapabilities);
        if (FMLEnvironment.dist.isClient()) {
            CuriosCompatClient.registerLayerDefinitions(modBus);
        }
        this.addPlayerInventoryHandlers();
    }

    public void onRegisterCapabilities(RegisterCapabilitiesEvent evt) {
        evt.registerItem(CuriosCapability.ITEM, (itemStack, unused) -> new CuriosBaubleItemWrapper((ItemStack)itemStack), new ItemLike[]{(ItemLike)ModItems.FORTUNE_COIN.get(), (ItemLike)ModItems.MOB_CHARM_BELT.get(), (ItemLike)ModItems.TWILIGHT_CLOAK.get()});
    }

    private void setup(FMLCommonSetupEvent event) {
        if (FMLEnvironment.dist.isClient()) {
            CuriosCompatClient.registerFortuneCoinToggler();
        }
        ModItems.MOB_CHARM.get().setCharmInventoryHandler(new CuriosCharmInventoryHandler());
    }

    public static Optional<ItemStack> getStackInSlot(LivingEntity entity, String slotName, int slot) {
        return CuriosApi.getCuriosInventory((LivingEntity)entity).flatMap(handler -> handler.getStacksHandler(slotName).map(sh -> sh.getStacks().getStackInSlot(slot)));
    }

    public static void setStackInSlot(LivingEntity entity, String slotName, int slot, ItemStack stack) {
        CuriosApi.getCuriosInventory((LivingEntity)entity).flatMap(handler -> handler.getStacksHandler(slotName)).ifPresent(sh -> sh.getStacks().setStackInSlot(slot, stack));
    }

    private static class EmptyCuriosHandler
    extends ItemStackHandler
    implements IDynamicStackHandler {
        private EmptyCuriosHandler() {
        }

        public void setPreviousStackInSlot(int i, @Nonnull ItemStack itemStack) {
        }

        public ItemStack getPreviousStackInSlot(int i) {
            return ItemStack.EMPTY;
        }

        public void grow(int i) {
        }

        public void shrink(int i) {
        }
    }
}

