/*
 * Decompiled with CFR 0.152.
 */
package reliquary.util;

import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class RegistryHelper {
    private RegistryHelper() {
    }

    public static String getItemRegistryName(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item).toString();
    }

    public static ResourceLocation getRegistryName(Item item) {
        return BuiltInRegistries.ITEM.getKey((Object)item);
    }

    public static ResourceLocation getRegistryName(Entity entity) {
        return RegistryHelper.getRegistryName(entity.getType());
    }

    public static ResourceLocation getRegistryName(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block);
    }

    public static ResourceLocation getRegistryName(EntityType<?> entityType) {
        return BuiltInRegistries.ENTITY_TYPE.getKey(entityType);
    }

    public static boolean registryNamesEqual(Item itemA, Item itemB) {
        return RegistryHelper.getRegistryName(itemA).equals((Object)RegistryHelper.getRegistryName(itemB));
    }

    public static ResourceLocation getRegistryName(MobEffect effect) {
        return Objects.requireNonNull(BuiltInRegistries.MOB_EFFECT.getKey((Object)effect));
    }
}

