/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui;

import appeng.api.stacks.GenericStack;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.WidgetContainer;
import appeng.client.gui.implementations.AESubScreen;
import appeng.client.gui.style.ScreenStyle;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.Tooltips;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.advanced_ae.gui.QuantumArmorFilterConfigMenu;
import org.jetbrains.annotations.NotNull;

public class QuantumArmorFilterScreen<M extends QuantumArmorFilterConfigMenu>
extends AEBaseScreen<M> {
    public QuantumArmorFilterScreen(M menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        AESubScreen.addBackButton(menu, (String)"back", (WidgetContainer)this.widgets);
    }

    public boolean mouseClicked(double xCoord, double yCoord, int btn) {
        if (((QuantumArmorFilterConfigMenu)this.menu).upgradeType == UpgradeType.AUTO_STOCK) {
            Slot slot;
            assert (this.minecraft != null);
            if (this.minecraft.options.keyPickItem.matchesMouse(btn) && this.isValidSlot(slot = this.findSlot(xCoord, yCoord))) {
                ((QuantumArmorFilterConfigMenu)this.menu).openAmountMenu(slot.index);
            }
        }
        return super.mouseClicked(xCoord, yCoord, btn);
    }

    protected void renderTooltip(@NotNull GuiGraphics guiGraphics, int x, int y) {
        if (((QuantumArmorFilterConfigMenu)this.menu).getCarried().isEmpty() && this.isValidSlot(this.hoveredSlot)) {
            ArrayList<Component> itemTooltip = new ArrayList<Component>(this.getTooltipFromContainerItem(this.hoveredSlot.getItem()));
            GenericStack unwrapped = GenericStack.fromItemStack((ItemStack)this.hoveredSlot.getItem());
            if (unwrapped != null) {
                itemTooltip.add(Tooltips.getAmountTooltip((ButtonToolTips)ButtonToolTips.Amount, (GenericStack)unwrapped));
            }
            itemTooltip.add(Tooltips.getSetAmountTooltip());
            this.drawTooltip(guiGraphics, x, y, itemTooltip);
        } else {
            super.renderTooltip(guiGraphics, x, y);
        }
    }

    private boolean isValidSlot(Slot slot) {
        return slot != null && slot.isActive() && slot.hasItem() && ((QuantumArmorFilterConfigMenu)this.menu).isConfigSlot(slot);
    }
}

