/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.renderer;

import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.IDynamicBakedModel;
import net.neoforged.neoforge.client.model.QuadTransformers;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.client.model.pipeline.QuadBakingVertexConsumer;
import net.pedroksl.advanced_ae.common.blocks.AAEAbstractCraftingUnitBlock;
import net.pedroksl.advanced_ae.common.blocks.AAECraftingUnitBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

abstract class QuantumComputerBaseBakedModel
implements IDynamicBakedModel {
    private final ChunkRenderTypeSet RENDER_TYPES;
    private static final Object2ReferenceMap<FaceCorner, List<Vector3f>> V_MAP = QuantumComputerBaseBakedModel.createVertexMap();
    private static final EnumMap<Direction, List<Vector3f>> F_MAP = QuantumComputerBaseBakedModel.createFaceMap();
    public static final ModelProperty<Connect> CONNECT_STATE = new ModelProperty();
    private static final int LU = 0;
    private static final int RU = 1;
    private static final int LD = 2;
    private static final int RD = 4;
    private final Function<AAECraftingUnitBlock, Boolean> connectCondition;
    private final TextureAtlasSprite face;
    private final TextureAtlasSprite sides;
    private final TextureAtlasSprite poweredSides;
    private HashMap<Direction, TextureAtlasSprite> faceAnimations;
    private boolean renderOppositeSide = false;
    private RenderType faceRenderType;
    private RenderType sideRenderType;
    private boolean isFaceEmissive = false;
    private boolean isSideEmissive = false;
    private boolean isFaceAnimationEmissive = false;

    QuantumComputerBaseBakedModel(RenderType renderType, TextureAtlasSprite face, TextureAtlasSprite sides, TextureAtlasSprite poweredSides, Function<AAECraftingUnitBlock, Boolean> connectCondition) {
        this(ChunkRenderTypeSet.of((RenderType[])new RenderType[]{renderType}), face, sides, poweredSides, connectCondition);
        this.faceRenderType = renderType;
        this.sideRenderType = renderType;
    }

    QuantumComputerBaseBakedModel(RenderType faceRenderType, RenderType sideRenderType, TextureAtlasSprite face, TextureAtlasSprite sides, TextureAtlasSprite poweredSides, Function<AAECraftingUnitBlock, Boolean> connectCondition) {
        this(ChunkRenderTypeSet.of((RenderType[])new RenderType[]{faceRenderType, sideRenderType}), face, sides, poweredSides, connectCondition);
        this.faceRenderType = faceRenderType;
        this.sideRenderType = sideRenderType;
    }

    private QuantumComputerBaseBakedModel(ChunkRenderTypeSet renderTypes, TextureAtlasSprite face, TextureAtlasSprite sides, TextureAtlasSprite poweredSides, Function<AAECraftingUnitBlock, Boolean> connectCondition) {
        this.RENDER_TYPES = renderTypes;
        this.face = face;
        this.sides = sides;
        this.poweredSides = poweredSides;
        this.connectCondition = connectCondition;
    }

    public void setFaceEmissive(boolean faceEmissive) {
        this.isFaceEmissive = faceEmissive;
    }

    public void setSideEmissive(boolean sideEmissive) {
        this.isSideEmissive = sideEmissive;
    }

    public void setFaceAnimation(HashMap<Direction, TextureAtlasSprite> faceAnimations, boolean emissive) {
        this.faceAnimations = faceAnimations;
        this.isFaceAnimationEmissive = emissive;
    }

    public void setRenderOppositeSide(boolean renderOppositeSide) {
        this.renderOppositeSide = renderOppositeSide;
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        Connect connect = new Connect();
        connect.init(pos);
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    AAECraftingUnitBlock block;
                    BlockPos offset = pos.offset(x, y, z);
                    Block block2 = world.getBlockState(offset).getAppearance(world, offset, Direction.NORTH, state, pos).getBlock();
                    if (!(block2 instanceof AAECraftingUnitBlock) || !this.connectCondition.apply(block = (AAECraftingUnitBlock)block2).booleanValue()) continue;
                    connect.set(x, y, z);
                }
            }
        }
        return modelData.derive().with(CONNECT_STATE, (Object)connect).build();
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState blockState, @Nullable Direction side, @NotNull RandomSource randomSource, @NotNull ModelData modelData, @Nullable RenderType renderType) {
        if (side == null) {
            return Collections.emptyList();
        }
        Connect connect = (Connect)modelData.get(CONNECT_STATE);
        if (connect == null) {
            return Collections.emptyList();
        }
        boolean powered = blockState != null && (Boolean)blockState.getValue((Property)AAEAbstractCraftingUnitBlock.POWERED) != false;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (renderType == null || this.RENDER_TYPES.contains(renderType)) {
            if (renderType == this.faceRenderType) {
                this.addQuad(quads, side, connect.getFace(side), powered);
            }
            if (this.sides != null && renderType == this.sideRenderType) {
                this.addSides(quads, connect, side, powered);
                if (this.renderOppositeSide) {
                    this.addSides(quads, connect, side.getOpposite(), powered, true);
                }
            }
        }
        return quads;
    }

    private void addSides(List<BakedQuad> quads, Connect connect, Direction side, boolean powered) {
        this.addSides(quads, connect, side, powered, false);
    }

    private void addSides(List<BakedQuad> quads, Connect connect, Direction side, boolean powered, boolean renderOpposite) {
        this.addQuad(quads, side, connect.getIndex(side, 0), 0, powered, renderOpposite);
        this.addQuad(quads, side, connect.getIndex(side, 1), 1, powered, renderOpposite);
        this.addQuad(quads, side, connect.getIndex(side, 2), 2, powered, renderOpposite);
        this.addQuad(quads, side, connect.getIndex(side, 4), 4, powered, renderOpposite);
    }

    private List<Vector3f> calculateCorners(Direction face, int corner) {
        return (List)V_MAP.get((Object)new FaceCorner(face, corner));
    }

    private void addQuad(List<BakedQuad> quads, Direction side, int index, boolean powered) {
        if (index < 0) {
            return;
        }
        List<Vector3f> cons = F_MAP.get(side);
        Vec3i normal = side.getNormal();
        Vector3f normalF = new Vector3f(this.getNormalStep(normal.getX()), this.getNormalStep(normal.getY()), this.getNormalStep(normal.getZ()));
        Vector3f c1 = new Vector3f((Vector3fc)cons.get(0)).sub((Vector3fc)normalF);
        Vector3f c2 = new Vector3f((Vector3fc)cons.get(1)).sub((Vector3fc)normalF);
        Vector3f c3 = new Vector3f((Vector3fc)cons.get(2)).sub((Vector3fc)normalF);
        Vector3f c4 = new Vector3f((Vector3fc)cons.get(3)).sub((Vector3fc)normalF);
        QuadBakingVertexConsumer builder = new QuadBakingVertexConsumer();
        builder.setSprite(this.face);
        builder.setDirection(side);
        builder.setShade(true);
        this.putVertex(builder, this.face, normal, c1.x(), c1.y(), c1.z(), 0.0f, 0.0f);
        this.putVertex(builder, this.face, normal, c2.x(), c2.y(), c2.z(), 0.0f, 1.0f);
        this.putVertex(builder, this.face, normal, c3.x(), c3.y(), c3.z(), 1.0f, 1.0f);
        this.putVertex(builder, this.face, normal, c4.x(), c4.y(), c4.z(), 1.0f, 0.0f);
        BakedQuad quad = builder.bakeQuad();
        if (this.isFaceEmissive && powered) {
            QuadTransformers.settingMaxEmissivity().processInPlace(quad);
        }
        quads.add(quad);
        if (powered && this.faceAnimations != null && this.faceAnimations.get(side) != null) {
            TextureAtlasSprite texture = this.faceAnimations.get(side);
            builder.setSprite(texture);
            builder.setDirection(side);
            builder.setShade(true);
            this.putVertex(builder, texture, normal, c1.x(), c1.y(), c1.z(), 0.0f, 0.0f);
            this.putVertex(builder, texture, normal, c2.x(), c2.y(), c2.z(), 0.0f, 1.0f);
            this.putVertex(builder, texture, normal, c3.x(), c3.y(), c3.z(), 1.0f, 1.0f);
            this.putVertex(builder, texture, normal, c4.x(), c4.y(), c4.z(), 1.0f, 0.0f);
            BakedQuad aniQuad = builder.bakeQuad();
            if (this.isFaceAnimationEmissive) {
                QuadTransformers.settingMaxEmissivity().processInPlace(aniQuad);
            }
            quads.add(aniQuad);
        }
    }

    private void addQuad(List<BakedQuad> quads, Direction side, int index, int corner, boolean powered, boolean renderOpposite) {
        Vector3f c4;
        if (index < 0) {
            return;
        }
        QuadBakingVertexConsumer builder = new QuadBakingVertexConsumer();
        List<Vector3f> cons = this.calculateCorners(side, corner);
        TextureAtlasSprite texture = powered ? this.poweredSides : this.sides;
        builder.setSprite(texture);
        builder.setDirection(side);
        builder.setShade(true);
        Vec3i normal = side.getNormal();
        Vector3f c1 = renderOpposite ? cons.get(3) : cons.get(0);
        Vector3f c2 = renderOpposite ? cons.get(2) : cons.get(1);
        Vector3f c3 = renderOpposite ? cons.get(1) : cons.get(2);
        Vector3f vector3f = c4 = renderOpposite ? cons.get(0) : cons.get(3);
        if (renderOpposite) {
            Vector3f normalF = new Vector3f(this.getNormalStep(normal.getX(), 2.0f), this.getNormalStep(normal.getY(), 2.0f), this.getNormalStep(normal.getZ(), 2.0f));
            c1 = new Vector3f((Vector3fc)c1).sub((Vector3fc)normalF);
            c2 = new Vector3f((Vector3fc)c2).sub((Vector3fc)normalF);
            c3 = new Vector3f((Vector3fc)c3).sub((Vector3fc)normalF);
            c4 = new Vector3f((Vector3fc)c4).sub((Vector3fc)normalF);
        }
        float u0 = renderOpposite ? this.getU1(index) : this.getU0(index);
        float u1 = renderOpposite ? this.getU0(index) : this.getU1(index);
        float v0 = this.getV0(index);
        float v1 = this.getV1(index);
        switch (corner) {
            case 0: {
                this.putVertex(builder, texture, normal, c1.x(), c1.y(), c1.z(), u0, v0);
                this.putVertex(builder, texture, normal, c2.x(), c2.y(), c2.z(), u0, v1);
                this.putVertex(builder, texture, normal, c3.x(), c3.y(), c3.z(), u1, v1);
                this.putVertex(builder, texture, normal, c4.x(), c4.y(), c4.z(), u1, v0);
                break;
            }
            case 1: {
                this.putVertex(builder, texture, normal, c1.x(), c1.y(), c1.z(), u1, v0);
                this.putVertex(builder, texture, normal, c2.x(), c2.y(), c2.z(), u1, v1);
                this.putVertex(builder, texture, normal, c3.x(), c3.y(), c3.z(), u0, v1);
                this.putVertex(builder, texture, normal, c4.x(), c4.y(), c4.z(), u0, v0);
                break;
            }
            case 2: {
                this.putVertex(builder, texture, normal, c1.x(), c1.y(), c1.z(), u0, v1);
                this.putVertex(builder, texture, normal, c2.x(), c2.y(), c2.z(), u0, v0);
                this.putVertex(builder, texture, normal, c3.x(), c3.y(), c3.z(), u1, v0);
                this.putVertex(builder, texture, normal, c4.x(), c4.y(), c4.z(), u1, v1);
                break;
            }
            case 4: {
                this.putVertex(builder, texture, normal, c1.x(), c1.y(), c1.z(), u1, v1);
                this.putVertex(builder, texture, normal, c2.x(), c2.y(), c2.z(), u1, v0);
                this.putVertex(builder, texture, normal, c3.x(), c3.y(), c3.z(), u0, v0);
                this.putVertex(builder, texture, normal, c4.x(), c4.y(), c4.z(), u0, v1);
            }
        }
        BakedQuad quad = builder.bakeQuad();
        if (this.isSideEmissive && powered) {
            QuadTransformers.settingMaxEmissivity().processInPlace(quad);
        }
        quads.add(quad);
    }

    private static EnumMap<Direction, List<Vector3f>> createFaceMap() {
        EnumMap<Direction, List<Vector3f>> map = new EnumMap<Direction, List<Vector3f>>(Direction.class);
        map.put(Direction.EAST, List.of(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f)));
        map.put(Direction.WEST, (List<Vector3f>)List.of(new Vector3f(0.0f, 1.0f, 1.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f)).reversed());
        map.put(Direction.UP, List.of(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 1.0f)));
        map.put(Direction.DOWN, (List<Vector3f>)List.of(new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 1.0f)).reversed());
        map.put(Direction.SOUTH, List.of(new Vector3f(0.0f, 1.0f, 1.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f)));
        map.put(Direction.NORTH, (List<Vector3f>)List.of(new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f)).reversed());
        return map;
    }

    private static Object2ReferenceMap<FaceCorner, List<Vector3f>> createVertexMap() {
        Object2ReferenceOpenHashMap map = new Object2ReferenceOpenHashMap();
        map.put((Object)new FaceCorner(Direction.EAST, 0), List.of(new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 0.5f, 1.0f), new Vector3f(1.0f, 0.5f, 0.5f), new Vector3f(1.0f, 1.0f, 0.5f)));
        map.put((Object)new FaceCorner(Direction.EAST, 1), List.of(new Vector3f(1.0f, 1.0f, 0.5f), new Vector3f(1.0f, 0.5f, 0.5f), new Vector3f(1.0f, 0.5f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f)));
        map.put((Object)new FaceCorner(Direction.EAST, 2), List.of(new Vector3f(1.0f, 0.5f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 0.5f), new Vector3f(1.0f, 0.5f, 0.5f)));
        map.put((Object)new FaceCorner(Direction.EAST, 4), List.of(new Vector3f(1.0f, 0.5f, 0.5f), new Vector3f(1.0f, 0.0f, 0.5f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.5f, 0.0f)));
        map.put((Object)new FaceCorner(Direction.WEST, 0), List.of(new Vector3f(0.0f, 1.0f, 0.0f), new Vector3f(0.0f, 0.5f, 0.0f), new Vector3f(0.0f, 0.5f, 0.5f), new Vector3f(0.0f, 1.0f, 0.5f)));
        map.put((Object)new FaceCorner(Direction.WEST, 1), List.of(new Vector3f(0.0f, 1.0f, 0.5f), new Vector3f(0.0f, 0.5f, 0.5f), new Vector3f(0.0f, 0.5f, 1.0f), new Vector3f(0.0f, 1.0f, 1.0f)));
        map.put((Object)new FaceCorner(Direction.WEST, 2), List.of(new Vector3f(0.0f, 0.5f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.5f), new Vector3f(0.0f, 0.5f, 0.5f)));
        map.put((Object)new FaceCorner(Direction.WEST, 4), List.of(new Vector3f(0.0f, 0.5f, 0.5f), new Vector3f(0.0f, 0.0f, 0.5f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.5f, 1.0f)));
        map.put((Object)new FaceCorner(Direction.SOUTH, 0), List.of(new Vector3f(0.0f, 1.0f, 1.0f), new Vector3f(0.0f, 0.5f, 1.0f), new Vector3f(0.5f, 0.5f, 1.0f), new Vector3f(0.5f, 1.0f, 1.0f)));
        map.put((Object)new FaceCorner(Direction.SOUTH, 1), List.of(new Vector3f(0.5f, 1.0f, 1.0f), new Vector3f(0.5f, 0.5f, 1.0f), new Vector3f(1.0f, 0.5f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f)));
        map.put((Object)new FaceCorner(Direction.SOUTH, 2), List.of(new Vector3f(0.0f, 0.5f, 1.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.5f, 0.0f, 1.0f), new Vector3f(0.5f, 0.5f, 1.0f)));
        map.put((Object)new FaceCorner(Direction.SOUTH, 4), List.of(new Vector3f(0.5f, 0.5f, 1.0f), new Vector3f(0.5f, 0.0f, 1.0f), new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(1.0f, 0.5f, 1.0f)));
        map.put((Object)new FaceCorner(Direction.NORTH, 0), List.of(new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 0.5f, 0.0f), new Vector3f(0.5f, 0.5f, 0.0f), new Vector3f(0.5f, 1.0f, 0.0f)));
        map.put((Object)new FaceCorner(Direction.NORTH, 1), List.of(new Vector3f(0.5f, 1.0f, 0.0f), new Vector3f(0.5f, 0.5f, 0.0f), new Vector3f(0.0f, 0.5f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f)));
        map.put((Object)new FaceCorner(Direction.NORTH, 2), List.of(new Vector3f(1.0f, 0.5f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.5f, 0.0f, 0.0f), new Vector3f(0.5f, 0.5f, 0.0f)));
        map.put((Object)new FaceCorner(Direction.NORTH, 4), List.of(new Vector3f(0.5f, 0.5f, 0.0f), new Vector3f(0.5f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.5f, 0.0f)));
        map.put((Object)new FaceCorner(Direction.UP, 0), List.of(new Vector3f(0.0f, 1.0f, 1.0f), new Vector3f(0.5f, 1.0f, 1.0f), new Vector3f(0.5f, 1.0f, 0.5f), new Vector3f(0.0f, 1.0f, 0.5f)));
        map.put((Object)new FaceCorner(Direction.UP, 1), List.of(new Vector3f(0.0f, 1.0f, 0.5f), new Vector3f(0.5f, 1.0f, 0.5f), new Vector3f(0.5f, 1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f)));
        map.put((Object)new FaceCorner(Direction.UP, 2), List.of(new Vector3f(0.5f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(1.0f, 1.0f, 0.5f), new Vector3f(0.5f, 1.0f, 0.5f)));
        map.put((Object)new FaceCorner(Direction.UP, 4), List.of(new Vector3f(0.5f, 1.0f, 0.5f), new Vector3f(1.0f, 1.0f, 0.5f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(0.5f, 1.0f, 0.0f)));
        map.put((Object)new FaceCorner(Direction.DOWN, 0), List.of(new Vector3f(1.0f, 0.0f, 1.0f), new Vector3f(0.5f, 0.0f, 1.0f), new Vector3f(0.5f, 0.0f, 0.5f), new Vector3f(1.0f, 0.0f, 0.5f)));
        map.put((Object)new FaceCorner(Direction.DOWN, 1), List.of(new Vector3f(1.0f, 0.0f, 0.5f), new Vector3f(0.5f, 0.0f, 0.5f), new Vector3f(0.5f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f)));
        map.put((Object)new FaceCorner(Direction.DOWN, 2), List.of(new Vector3f(0.5f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(0.0f, 0.0f, 0.5f), new Vector3f(0.5f, 0.0f, 0.5f)));
        map.put((Object)new FaceCorner(Direction.DOWN, 4), List.of(new Vector3f(0.5f, 0.0f, 0.5f), new Vector3f(0.0f, 0.0f, 0.5f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.5f, 0.0f, 0.0f)));
        return map;
    }

    private void putVertex(QuadBakingVertexConsumer builder, TextureAtlasSprite sprite, Vec3i normal, float x, float y, float z, float u, float v) {
        builder.addVertex(x, y, z);
        builder.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        builder.setNormal((float)normal.getX(), (float)normal.getY(), (float)normal.getZ());
        u = sprite.getU(u);
        v = sprite.getV(v);
        builder.setUv(u, v);
    }

    private float getU0(int index) {
        return switch (index) {
            case 1, 3 -> 0.5f;
            default -> 0.0f;
        };
    }

    private float getU1(int index) {
        return switch (index) {
            case 1, 3 -> 1.0f;
            default -> 0.5f;
        };
    }

    private float getV0(int index) {
        return switch (index) {
            case 2, 3 -> 0.5f;
            default -> 0.0f;
        };
    }

    private float getV1(int index) {
        return switch (index) {
            case 2, 3 -> 1.0f;
            default -> 0.5f;
        };
    }

    public boolean useAmbientOcclusion() {
        return false;
    }

    public boolean isGui3d() {
        return false;
    }

    public boolean isCustomRenderer() {
        return false;
    }

    @NotNull
    public TextureAtlasSprite getParticleIcon() {
        return this.sides;
    }

    public boolean usesBlockLight() {
        return false;
    }

    @NotNull
    public ItemOverrides getOverrides() {
        return ItemOverrides.EMPTY;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public ChunkRenderTypeSet getRenderTypes(BlockState state, RandomSource rand, ModelData data) {
        return this.RENDER_TYPES;
    }

    private float getNormalStep(int step) {
        return this.getNormalStep(step, 1.0f);
    }

    private float getNormalStep(int step, float multiplier) {
        return multiplier * (step > 0 ? 0.001f : (step < 0 ? -0.001f : 0.0f));
    }

    public static class Connect {
        private final boolean[][][] connects = new boolean[3][3][3];
        private int face;

        int getFace(Direction face) {
            if (this.blocked(face)) {
                return -1;
            }
            return this.face;
        }

        void init(BlockPos pos) {
            this.face = Math.abs((pos.getX() ^ pos.getY() ^ pos.getZ()) % 3);
        }

        void set(int x, int y, int z) {
            this.connects[x + 1][y + 1][z + 1] = true;
        }

        int getIndex(Direction face, int corner) {
            if (this.blocked(face)) {
                return -1;
            }
            return switch (face) {
                default -> throw new MatchException(null, null);
                case Direction.WEST, Direction.EAST -> this.getIndexX(face, corner);
                case Direction.DOWN, Direction.UP -> this.getIndexY(face, corner);
                case Direction.NORTH, Direction.SOUTH -> this.getIndexZ(face, corner);
            };
        }

        boolean blocked(Direction face) {
            Vec3i pos = face.getNormal().offset(1, 1, 1);
            return this.connects[pos.getX()][pos.getY()][pos.getZ()];
        }

        int getIndexX(Direction face, int corner) {
            int x = face.getStepX();
            return switch (corner) {
                case 0 -> this.getIndex(this.connects[1][1][1 + x], this.connects[1][2][1], this.connects[1][2][1 + x]);
                case 1 -> this.getIndex(this.connects[1][1][1 - x], this.connects[1][2][1], this.connects[1][2][1 - x]);
                case 2 -> this.getIndex(this.connects[1][1][1 + x], this.connects[1][0][1], this.connects[1][0][1 + x]);
                case 4 -> this.getIndex(this.connects[1][1][1 - x], this.connects[1][0][1], this.connects[1][0][1 - x]);
                default -> -1;
            };
        }

        int getIndexZ(Direction face, int corner) {
            int z = face.getStepZ();
            return switch (corner) {
                case 0 -> this.getIndex(this.connects[1 - z][1][1], this.connects[1][2][1], this.connects[1 - z][2][1]);
                case 1 -> this.getIndex(this.connects[1 + z][1][1], this.connects[1][2][1], this.connects[1 + z][2][1]);
                case 2 -> this.getIndex(this.connects[1 - z][1][1], this.connects[1][0][1], this.connects[1 - z][0][1]);
                case 4 -> this.getIndex(this.connects[1 + z][1][1], this.connects[1][0][1], this.connects[1 + z][0][1]);
                default -> -1;
            };
        }

        int getIndexY(Direction face, int corner) {
            int y = face.getStepY();
            return switch (corner) {
                case 0 -> this.getIndex(this.connects[1][1][2], this.connects[1 - y][1][1], this.connects[1 - y][1][2]);
                case 1 -> this.getIndex(this.connects[1][1][0], this.connects[1 - y][1][1], this.connects[1 - y][1][0]);
                case 2 -> this.getIndex(this.connects[1][1][2], this.connects[1 + y][1][1], this.connects[1 + y][1][2]);
                case 4 -> this.getIndex(this.connects[1][1][0], this.connects[1 + y][1][1], this.connects[1 + y][1][0]);
                default -> -1;
            };
        }

        int getIndex(boolean a, boolean b, boolean c) {
            if (!a && !b) {
                return 0;
            }
            if (a && b && !c) {
                return 1;
            }
            if (!a && b) {
                return 2;
            }
            if (a && !b) {
                return 3;
            }
            return -1;
        }
    }

    private record FaceCorner(Direction face, int corner) {
    }
}

