/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.helpers;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.core.Direction;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.pedroksl.advanced_ae.common.helpers.NullableDirectionListCodec;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum NullableDirection implements StringRepresentable
{
    DOWN(0, Direction.DOWN),
    UP(1, Direction.UP),
    NORTH(2, Direction.NORTH),
    SOUTH(3, Direction.SOUTH),
    WEST(4, Direction.WEST),
    EAST(5, Direction.EAST),
    NULLDIR(6, null);

    public static final IntFunction<NullableDirection> BY_ID;
    private final int index;
    private final Direction dir;
    public static final StringRepresentable.EnumCodec<NullableDirection> CODEC;
    public static final StreamCodec<ByteBuf, NullableDirection> STREAM_CODEC;
    public static final Codec<List<@Nullable NullableDirection>> FAULT_TOLERANT_NULLABLE_LIST_CODEC;

    private NullableDirection(int index, Direction dir) {
        this.index = index;
        this.dir = dir;
    }

    public int getIndex() {
        return this.index;
    }

    public Direction getDirection() {
        return this.dir;
    }

    public static NullableDirection fromDirection(Direction dir) {
        if (dir == null) {
            return NULLDIR;
        }
        return switch (dir) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> DOWN;
            case Direction.UP -> UP;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.EAST -> EAST;
        };
    }

    @NotNull
    public String getSerializedName() {
        if (this.dir == null) {
            return "null";
        }
        return this.dir.name();
    }

    static {
        BY_ID = ByIdMap.continuous(NullableDirection::getIndex, (Object[])NullableDirection.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.WRAP);
        CODEC = StringRepresentable.fromEnum(NullableDirection::values);
        STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, NullableDirection::getIndex);
        FAULT_TOLERANT_NULLABLE_LIST_CODEC = new NullableDirectionListCodec((Codec<NullableDirection>)CODEC);
    }
}

