/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.entity.ai;

import alexthw.ars_elemental.common.entity.ai.ProjCastingGoal;
import alexthw.ars_elemental.common.entity.mages.EntityMageBase;
import java.util.function.Supplier;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class MageProjCastingGoal<T extends EntityMageBase>
extends ProjCastingGoal<T> {
    public MageProjCastingGoal(T entity, double speed, int attackInterval, float attackRange, Supplier<Boolean> canUse, int animId, int delayTicks) {
        super(entity, speed, attackInterval, attackRange, canUse, animId, delayTicks);
    }

    @Override
    public void tick() {
        LivingEntity livingentity = ((EntityMageBase)this.mob).getTarget();
        if (livingentity == null) {
            return;
        }
        double d0 = ((EntityMageBase)this.mob).distanceToSqr(livingentity.getX(), livingentity.getY(), livingentity.getZ());
        boolean canSeeEnemy = ((EntityMageBase)this.mob).getSensing().hasLineOfSight((Entity)livingentity);
        double minDistanceSqr = (double)this.attackRadiusSqr * 0.5 * 0.5;
        double maxDistanceSqr = (double)this.attackRadiusSqr * 1.5 * 1.5;
        double maxAggroSqr = (double)this.attackRadiusSqr * 2.0 * 2.0;
        if (canSeeEnemy != this.seeTime > 0) {
            this.seeTime = 0;
        }
        this.seeTime = canSeeEnemy ? ++this.seeTime : --this.seeTime;
        if (d0 > maxDistanceSqr) {
            this.strafingBackwards = false;
            ((EntityMageBase)this.mob).getNavigation().moveTo((Entity)livingentity, this.speedModifier);
            this.strafingTime = -1;
        } else if (d0 < minDistanceSqr) {
            this.strafingBackwards = !(d0 > maxAggroSqr);
            ((EntityMageBase)this.mob).getNavigation().stop();
        } else {
            ((EntityMageBase)this.mob).getNavigation().stop();
            ++this.strafingTime;
        }
        if (this.strafingTime >= 20) {
            if ((double)((EntityMageBase)this.mob).getRandom().nextFloat() < 0.3) {
                boolean bl = this.strafingClockwise = !this.strafingClockwise;
            }
            if ((double)((EntityMageBase)this.mob).getRandom().nextFloat() < 0.3) {
                this.strafingBackwards = false;
            }
            this.strafingTime = 0;
        }
        if (this.strafingTime > -1) {
            float strafeSpeed = (float)Math.min(0.5, Math.sqrt(d0) / Math.sqrt(this.attackRadiusSqr));
            ((EntityMageBase)this.mob).getMoveControl().strafe(this.strafingBackwards ? -strafeSpeed : strafeSpeed, this.strafingClockwise ? strafeSpeed : -strafeSpeed);
            ((EntityMageBase)this.mob).lookAt((Entity)livingentity, 30.0f, 30.0f);
        } else {
            ((EntityMageBase)this.mob).getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
        }
        this.animationChecks(livingentity);
    }
}

