/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.rituals;

import alexthw.ars_elemental.ArsElemental;
import com.hollingsworth.arsnouveau.api.ritual.AbstractRitual;
import com.hollingsworth.arsnouveau.client.particle.ParticleColor;
import com.hollingsworth.arsnouveau.client.particle.ParticleUtil;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;

public class DetectionRitual
extends AbstractRitual {
    public static String ID = "ritual_detection";

    public String getName() {
        return "Detection";
    }

    public String getLangDescription() {
        return "Makes all monsters in a 128 blocks radius glow for 10 minutes.";
    }

    protected void tick() {
        Level level;
        if (this.getWorld() == null) {
            return;
        }
        ParticleUtil.spawnFallingSkyEffect((AbstractRitual)this.tile.ritual, (BlockEntity)this.tile, (RandomSource)this.rand, (ParticleColor.IntWrapper)this.getCenterColor().toWrapper());
        if (this.getWorld().getGameTime() % 20L == 0L && !this.getWorld().isClientSide()) {
            this.incrementProgress();
        }
        if ((level = this.getWorld()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (this.getProgress() >= 15) {
                List entities = level2.getEntitiesOfClass(Monster.class, new AABB(this.tile.getBlockPos()).inflate(128.0));
                for (LivingEntity entity : entities) {
                    entity.addEffect(new MobEffectInstance(MobEffects.GLOWING, 12000, 0, false, false));
                }
                this.setFinished();
            }
        }
    }

    public ParticleColor getCenterColor() {
        return new ParticleColor(100 + this.rand.nextInt(155), 50 + this.rand.nextInt(200), this.rand.nextInt(250));
    }

    public int getSourceCost() {
        return 250;
    }

    public String getLangName() {
        return "Detection";
    }

    public ResourceLocation getRegistryName() {
        return ArsElemental.prefix(ID);
    }
}

