/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.pmapi.menu;

import com.mojang.realmsclient.RealmsMainScreen;
import dev.ftb.mods.pmapi.PauseMenuMod;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.GenericMessageScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.ShareToLanScreen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.achievement.StatsScreen;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.gui.screens.multiplayer.ServerLinksScreen;
import net.minecraft.client.gui.screens.options.OptionsScreen;
import net.minecraft.client.gui.screens.social.SocialInteractionsScreen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerLinks;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.ModListScreen;

public class OriginalPauseScreenImpl
extends Screen {
    private static final ResourceLocation DRAFT_REPORT_SPRITE = ResourceLocation.withDefaultNamespace((String)"icon/draft_report");
    public static final Component RETURN_TO_GAME = Component.translatable((String)"menu.returnToGame");
    public static final Component ADVANCEMENTS = Component.translatable((String)"gui.advancements");
    public static final Component STATS = Component.translatable((String)"gui.stats");
    public static final Component SERVER_LINKS = Component.translatable((String)"menu.server_links");
    public static final Component OPTIONS = Component.translatable((String)"menu.options");
    public static final Component SHARE_TO_LAN = Component.translatable((String)"menu.shareToLan");
    public static final Component PLAYER_REPORTING = Component.translatable((String)"menu.playerReporting");
    public static final Component RETURN_TO_MENU = Component.translatable((String)"menu.returnToMenu");
    private static final int BUTTON_WIDTH_HALF = 98;
    private static final int BUTTON_WIDTH_FULL = 204;
    @Nullable
    private Button disconnectButton;

    public OriginalPauseScreenImpl() {
        super((Component)Component.translatable((String)"menu.game"));
    }

    protected void init() {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        this.addRenderableWidget((GuiEventListener)new StringWidget(0, 40, this.width, 9, this.title, this.font));
        GridLayout layout = new GridLayout();
        layout.defaultCellSetting().padding(4, 4, 4, 0);
        GridLayout.RowHelper rowHelper = layout.createRowHelper(2);
        rowHelper.addChild((LayoutElement)Button.builder((Component)RETURN_TO_GAME, p_280814_ -> {
            mc.setScreen(null);
            mc.mouseHandler.grabMouse();
        }).width(204).build(), 2, layout.newCellSettings().paddingTop(50));
        Boolean advancementsDisabled = (Boolean)PauseMenuMod.config().removeAdvancementsButton.get();
        if (!advancementsDisabled.booleanValue()) {
            rowHelper.addChild((LayoutElement)this.openScreenButton(ADVANCEMENTS, () -> new AdvancementsScreen(player.connection.getAdvancements(), (Screen)this)));
        }
        rowHelper.addChild((LayoutElement)this.openScreenButton(STATS, () -> new StatsScreen((Screen)this, player.getStats())));
        ServerLinks serverlinks = player.connection.serverLinks();
        if (!serverlinks.isEmpty()) {
            rowHelper.addChild((LayoutElement)this.openScreenButton(SERVER_LINKS, () -> new ServerLinksScreen((Screen)this, serverlinks)));
        }
        rowHelper.addChild((LayoutElement)this.openScreenButton(OPTIONS, () -> new OptionsScreen((Screen)this, mc.options)));
        if (mc.hasSingleplayerServer() && !mc.getSingleplayerServer().isPublished()) {
            rowHelper.addChild((LayoutElement)this.openScreenButton(SHARE_TO_LAN, () -> new ShareToLanScreen((Screen)this)));
        } else {
            rowHelper.addChild((LayoutElement)this.openScreenButton(PLAYER_REPORTING, () -> new SocialInteractionsScreen((Screen)this)));
        }
        Button.Builder modsButtonBuilder = Button.builder((Component)Component.translatable((String)"ftbpmapi.generic.mods", (Object[])new Object[]{ModList.get().size()}), button -> mc.setScreen((Screen)new ModListScreen((Screen)this))).width(advancementsDisabled != false ? 98 : 204);
        rowHelper.addChild((LayoutElement)modsButtonBuilder.build(), advancementsDisabled != false ? 1 : 2);
        Component component = mc.isLocalServer() ? RETURN_TO_MENU : CommonComponents.GUI_DISCONNECT;
        this.disconnectButton = (Button)rowHelper.addChild((LayoutElement)Button.builder((Component)component, button -> {
            button.active = false;
            mc.getReportingContext().draftReportHandled(mc, (Screen)this, this::onDisconnect, true);
        }).width(204).build(), 2);
        layout.arrangeElements();
        FrameLayout.alignInRectangle((LayoutElement)layout, (int)0, (int)0, (int)this.width, (int)this.height, (float)0.5f, (float)0.25f);
        layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    public void onDisconnect() {
        Minecraft mc = Minecraft.getInstance();
        boolean flag = mc.isLocalServer();
        ServerData serverdata = mc.getCurrentServer();
        mc.level.disconnect();
        if (flag) {
            mc.disconnect((Screen)new GenericMessageScreen(ConfigurationScreen.SAVING_LEVEL));
        } else {
            mc.disconnect();
        }
        TitleScreen titlescreen = new TitleScreen();
        if (flag) {
            mc.setScreen((Screen)titlescreen);
        } else if (serverdata != null && serverdata.isRealm()) {
            mc.setScreen((Screen)new RealmsMainScreen((Screen)titlescreen));
        } else {
            mc.setScreen((Screen)new JoinMultiplayerScreen((Screen)titlescreen));
        }
    }

    public Button openScreenButton(Component message, Supplier<Screen> screenSupplier) {
        return Button.builder((Component)message, p_280817_ -> Minecraft.getInstance().setScreen((Screen)screenSupplier.get())).width(98).build();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null) {
            return;
        }
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        if (mc.getReportingContext().hasDraftReport() && this.disconnectButton != null) {
            guiGraphics.blitSprite(DRAFT_REPORT_SPRITE, this.disconnectButton.getX() + this.disconnectButton.getWidth() - 17, this.disconnectButton.getY() + 3, 15, 15);
        }
    }
}

