/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.CrashUtilCommands.PlayerCommands;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.WorldUtils;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class UnstuckCommand
implements Command<CommandSourceStack> {
    private static final UnstuckCommand cmd = new UnstuckCommand();

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.literal((String)"unstuck").then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).suggests(CommandUtils.PROFILEPROVIDER).executes((Command)cmd));
    }

    public int run(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String name = StringArgumentType.getString(context, (String)"name");
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayerByName(name);
        AtomicReference<Boolean> success = new AtomicReference<Boolean>();
        if (player == null) {
            success.set(WorldUtils.applyToPlayer(name, ((CommandSourceStack)context.getSource()).getServer(), fakePlayer -> {
                ServerLevel overworld = ((CommandSourceStack)context.getSource()).getServer().getLevel(Level.OVERWORLD);
                BlockPos spawn = overworld.getSharedSpawnPos();
                fakePlayer.setLevel((Level)overworld);
                fakePlayer.setPos((double)spawn.getX(), (double)spawn.getY(), (double)spawn.getZ());
            }));
        } else {
            BlockPos p = ((CommandSourceStack)context.getSource()).getServer().getLevel(Level.OVERWORLD).getSharedSpawnPos();
            WorldUtils.teleportPlayer((Player)player, player.getCommandSenderWorld(), (Level)player.getServer().getLevel(Level.OVERWORLD), p);
        }
        if (((Boolean)success.get()).booleanValue()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtils.CreateTextComponent("Sent Player " + name + " to Spawn"), true);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandUtils.CreateTextComponent("Unable to load playerdata for " + name), true);
        }
        return 0;
    }
}

