/*
 * Decompiled with CFR 0.152.
 */
package de.cech12.bucketlib.api.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.cech12.bucketlib.BucketLibMod;
import de.cech12.bucketlib.platform.Services;
import de.cech12.bucketlib.util.BucketLibUtil;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidIngredient
implements ICustomIngredient {
    protected final Fluid fluid;
    protected final TagKey<Fluid> tag;
    private ItemStack[] matchingStacks;
    public static final MapCodec<FluidIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)ResourceLocation.CODEC.optionalFieldOf("fluid").forGetter(i -> Optional.of(BuiltInRegistries.FLUID.getKey((Object)i.fluid))), (App)TagKey.codec((ResourceKey)BuiltInRegistries.FLUID.key()).optionalFieldOf("tag").forGetter(i -> Optional.ofNullable(i.tag))).apply((Applicative)builder, FluidIngredient::new));
    public static final IngredientType<FluidIngredient> TYPE = new IngredientType(CODEC);

    private FluidIngredient(Fluid fluid, TagKey<Fluid> tag) {
        this.fluid = fluid;
        this.tag = tag;
    }

    public FluidIngredient(Optional<ResourceLocation> fluidOptional, Optional<TagKey<Fluid>> tagOptional) {
        this(fluidOptional.map(arg_0 -> ((DefaultedRegistry)BuiltInRegistries.FLUID).get(arg_0)).orElse(null), (TagKey<Fluid>)((TagKey)tagOptional.orElse(null)));
    }

    public FluidIngredient(Fluid fluid) {
        this(fluid, null);
    }

    public FluidIngredient(TagKey<Fluid> tag) {
        this((Fluid)null, tag);
    }

    private boolean isFluidCorrect(Fluid fluid) {
        return fluid != null && (this.fluid != null && fluid.isSame(this.fluid) || this.tag != null && fluid.defaultFluidState().is(this.tag));
    }

    public boolean test(@Nonnull ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return false;
        }
        ResourceLocation location = BuiltInRegistries.ITEM.getKey((Object)itemStack.getItem());
        if ("mekanism".equals(location.getNamespace()) && itemStack.getCraftingRemainingItem().isEmpty()) {
            return false;
        }
        ItemStack container = itemStack.copyWithCount(1);
        Optional<FluidStack> drainedFluidOptional = FluidUtil.getFluidHandler((ItemStack)container).map(fluidHandler -> fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE));
        if (drainedFluidOptional.isPresent() && !drainedFluidOptional.get().isEmpty()) {
            FluidStack drainedFluid = drainedFluidOptional.get();
            return this.isFluidCorrect(drainedFluid.getFluid()) && drainedFluid.getAmount() == 1000;
        }
        return false;
    }

    @Nonnull
    public Stream<ItemStack> getItems() {
        if (this.matchingStacks == null) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            ArrayList<Fluid> fluids = new ArrayList<Fluid>();
            Optional fluidTag = Optional.empty();
            if (this.tag != null) {
                fluidTag = BuiltInRegistries.FLUID.getTag(this.tag);
            }
            if (fluidTag.isPresent()) {
                ((HolderSet.Named)fluidTag.get()).forEach(fluid -> fluids.add((Fluid)fluid.value()));
            } else if (this.fluid != null) {
                fluids.add(this.fluid);
            }
            for (Fluid fluid2 : fluids) {
                Item bucketItem = fluid2.getBucket();
                if (!(bucketItem instanceof BucketItem) || Services.BUCKET.getFluidOfBucketItem((BucketItem)bucketItem) != fluid2) continue;
                stacks.add(new ItemStack((ItemLike)bucketItem));
                BucketLibMod.getRegisteredBuckets().forEach(universalBucketItem -> {
                    if (universalBucketItem.canHoldFluid(fluid2)) {
                        stacks.add(BucketLibUtil.addFluid(new ItemStack((ItemLike)universalBucketItem), fluid2));
                    }
                });
            }
            this.matchingStacks = stacks.toArray(new ItemStack[0]);
        }
        return Stream.of(this.matchingStacks);
    }

    public boolean isSimple() {
        return false;
    }

    @Nonnull
    public IngredientType<?> getType() {
        return TYPE;
    }
}

