/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability;

import artifacts.component.ability.EquipmentAbility;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.equipment.EquipmentHelper;
import artifacts.registry.ModDataComponents;
import artifacts.util.ModCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public record PostDamageCooldown(Value<Integer> cooldown, Optional<TagKey<DamageType>> tag) implements EquipmentAbility
{
    public static final Codec<PostDamageCooldown> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ValueTypes.DURATION.codec().fieldOf("cooldown").forGetter(PostDamageCooldown::cooldown), (App)TagKey.codec((ResourceKey)Registries.DAMAGE_TYPE).optionalFieldOf("tag").forGetter(PostDamageCooldown::tag)).apply((Applicative)instance, PostDamageCooldown::new));
    public static final StreamCodec<ByteBuf, PostDamageCooldown> STREAM_CODEC = StreamCodec.composite(ValueTypes.DURATION.streamCodec(), PostDamageCooldown::cooldown, (StreamCodec)ByteBufCodecs.optional(ModCodecs.tagKeyStreamCodec(Registries.DAMAGE_TYPE)), PostDamageCooldown::tag, PostDamageCooldown::new);

    public static void onLivingDamaged(LivingEntity entity, DamageSource damageSource) {
        Player player;
        if (entity instanceof Player && !(player = (Player)entity).level().isClientSide()) {
            EquipmentHelper.iterateAbilities(ModDataComponents.POST_DAMAGE_COOLDOWN.get(), entity, true, true, (ability, stack) -> {
                int c;
                if ((ability.tag().isEmpty() || damageSource.is(ability.tag().get())) && (c = (Integer)ability.cooldown().get() * 20) > 0) {
                    player.getCooldowns().addCooldown(stack.getItem(), c);
                }
            });
        }
    }

    @Override
    public boolean isNonCosmetic() {
        return (Integer)this.cooldown.get() > 0;
    }
}

