/*
 * Decompiled with CFR 0.152.
 */
package artifacts.component.ability.mobeffect;

import artifacts.component.ability.CompositeAbility;
import artifacts.component.ability.EquipmentAbility;
import artifacts.component.ability.mobeffect.MobEffectProvider;
import artifacts.config.value.Value;
import artifacts.config.value.ValueTypes;
import artifacts.equipment.EquipmentHelper;
import artifacts.registry.ModDataComponents;
import artifacts.util.ModCodecs;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;

public record PostDamageEffects(List<Entry> entries) implements CompositeAbility<Entry>
{
    public static final Codec<PostDamageEffects> CODEC = Entry.CODEC.listOf(0, 16).xmap(PostDamageEffects::new, PostDamageEffects::entries);
    public static final StreamCodec<RegistryFriendlyByteBuf, PostDamageEffects> STREAM_CODEC = ByteBufCodecs.list().apply(Entry.STREAM_CODEC).map(PostDamageEffects::new, PostDamageEffects::entries);

    public static void onLivingDamaged(LivingEntity entity, DamageSource damageSource) {
        if (!entity.level().isClientSide()) {
            EquipmentHelper.iterateAbilities(ModDataComponents.POST_DAMAGE_EFFECTS.get(), entity, true, true, (ability, stack) -> {
                for (Entry entry : ability.entries) {
                    if (!entry.shouldApply(damageSource.type(), entity)) continue;
                    entity.addEffect(entry.provider.createEffect());
                }
            });
        }
    }

    public record Entry(MobEffectProvider provider, Optional<TagKey<DamageType>> tag, Value<Double> chance) implements EquipmentAbility
    {
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MobEffectProvider.codec(true).fieldOf("effect").forGetter(Entry::provider), (App)TagKey.codec((ResourceKey)Registries.DAMAGE_TYPE).optionalFieldOf("tag").forGetter(Entry::tag), (App)ValueTypes.FRACTION.codec().optionalFieldOf("chance", Value.of(1.0)).forGetter(Entry::chance)).apply((Applicative)instance, Entry::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, Entry> STREAM_CODEC = StreamCodec.composite(MobEffectProvider.STREAM_CODEC, Entry::provider, (StreamCodec)ByteBufCodecs.optional(ModCodecs.tagKeyStreamCodec(Registries.DAMAGE_TYPE)), Entry::tag, ValueTypes.FRACTION.streamCodec(), Entry::chance, Entry::new);

        public boolean shouldApply(DamageType type, LivingEntity entity) {
            return this.provider.canApply(entity) && entity.getRandom().nextDouble() < (Double)this.chance.get() && (this.tag.isEmpty() || (Boolean)entity.level().registryAccess().registry(Registries.DAMAGE_TYPE).flatMap(registry -> registry.getTag(this.tag.get()).map(tag -> tag.contains(registry.wrapAsHolder((Object)type)))).orElseThrow() != false);
        }

        @Override
        public boolean isNonCosmetic() {
            return this.provider.isNonCosmetic() && (Double)this.chance.get() > 0.0;
        }

        @Override
        public void addToTooltip(EquipmentAbility.TooltipWriter writer) {
            if (this.provider.mobEffect().equals((Object)MobEffects.FIRE_RESISTANCE) && this.tag.isPresent() && this.tag.get().equals((Object)DamageTypeTags.IS_FIRE) && (Double)this.chance.get() == 1.0) {
                writer.add("fire_resistance", new Object[0]);
            } else if (this.provider.mobEffect().equals((Object)MobEffects.MOVEMENT_SPEED) && this.tag.isEmpty() && (Double)this.chance.get() == 1.0) {
                writer.add("speed", new Object[0]);
            }
        }
    }
}

