/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedexcrafting.block.entity;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.block.PackagedAutoBlocks;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedexcrafting.block.entity.MarkedPedestalBlockEntity;
import thelm.packagedexcrafting.block.entity.PackagedExCraftingBlockEntities;
import thelm.packagedexcrafting.inventory.CombinationCrafterItemHandler;
import thelm.packagedexcrafting.menu.CombinationCrafterMenu;
import thelm.packagedexcrafting.recipe.ICombinationPackageRecipeInfo;

public class CombinationCrafterBlockEntity
extends BaseBlockEntity
implements IPackageCraftingMachine {
    public static int energyCapacity = 5000000;
    public static boolean drawMEEnergy = false;
    public int requiredPedestals = 0;
    public boolean isWorking = false;
    public long energyReq = 0L;
    public long remainingProgress = 0L;
    public int energyUsage = 0;
    public ICombinationPackageRecipeInfo currentRecipe;
    public List<BlockPos> pedestals = new ArrayList<BlockPos>();

    public CombinationCrafterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PackagedExCraftingBlockEntities.COMBINATION_CRAFTER.get(), pos, state);
        this.setItemHandler(new CombinationCrafterItemHandler(this));
        this.setEnergyStorage(new EnergyStorage((BaseBlockEntity)this, energyCapacity));
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.packagedexcrafting.combination_crafter");
    }

    public Component getMessage() {
        if (this.isWorking) {
            return null;
        }
        int usablePedestals = this.getEmptyPedestals().size();
        MutableComponent message = Component.translatable((String)"block.packagedexcrafting.combination_crafter.pedestals.usable", (Object[])new Object[]{usablePedestals});
        if (this.requiredPedestals > 0) {
            message.append("\n");
            message.append((Component)Component.translatable((String)"block.packagedexcrafting.combination_crafter.pedestals.required", (Object[])new Object[]{this.requiredPedestals}));
        }
        return message;
    }

    public void tick() {
        if (!this.level.isClientSide) {
            if (this.isWorking) {
                this.tickProcess();
                if (this.remainingProgress <= 0L) {
                    this.finishProcess();
                    this.ejectItems();
                }
            }
            this.chargeEnergy();
            if (this.level.getGameTime() % 8L == 0L) {
                this.ejectItems();
            }
        }
    }

    public boolean acceptPackage(IPackageRecipeInfo recipeInfo, List<ItemStack> stacks, Direction direction) {
        if (!this.isBusy() && recipeInfo.isValid() && recipeInfo instanceof ICombinationPackageRecipeInfo) {
            ICombinationPackageRecipeInfo recipe = (ICombinationPackageRecipeInfo)recipeInfo;
            List<ItemStack> pedestalInputs = recipe.getPedestalInputs();
            List<BlockPos> emptyPedestals = this.getEmptyPedestals();
            this.requiredPedestals = Math.max(this.requiredPedestals, pedestalInputs.size());
            if (emptyPedestals.size() >= pedestalInputs.size()) {
                this.pedestals.clear();
                this.pedestals.addAll(emptyPedestals.subList(0, pedestalInputs.size()));
                this.currentRecipe = recipe;
                this.isWorking = true;
                this.energyReq = this.remainingProgress = recipe.getEnergyRequired();
                this.energyUsage = recipe.getEnergyUsage();
                this.itemHandler.setStackInSlot(0, recipe.getCoreInput());
                for (int i = 0; i < this.pedestals.size(); ++i) {
                    ((MarkedPedestalBlockEntity)this.level.getBlockEntity(this.pedestals.get(i))).getItemHandler().setStackInSlot(0, pedestalInputs.get(i).copy());
                }
                this.setChanged();
                return true;
            }
        }
        return false;
    }

    public boolean isBusy() {
        return this.isWorking || !this.itemHandler.getStacks().subList(0, 2).stream().allMatch(ItemStack::isEmpty);
    }

    protected void tickProcess() {
        if (this.pedestals.stream().map(arg_0 -> ((Level)this.level).getBlockEntity(arg_0)).anyMatch(be -> !(be instanceof MarkedPedestalBlockEntity) || be.isRemoved())) {
            this.endProcess();
        } else {
            int energy = this.energyStorage.extractEnergy((int)Math.min((long)this.energyUsage, this.remainingProgress), false);
            this.remainingProgress -= (long)energy;
            if (!this.level.isClientSide) {
                this.spawnParticles(ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)(0xFF000000 | this.level.getRandom().nextInt())), this.worldPosition, 1.15, 2);
                if (this.shouldSpawnItemParticles()) {
                    for (BlockPos pedestalPos : this.pedestals) {
                        ItemStack stack = ((MarkedPedestalBlockEntity)this.level.getBlockEntity(pedestalPos)).getItemHandler().getStackInSlot(0);
                        this.spawnItemParticles(pedestalPos, stack);
                    }
                }
            }
        }
    }

    protected void finishProcess() {
        if (this.currentRecipe == null) {
            this.endProcess();
            return;
        }
        if (this.pedestals.stream().map(arg_0 -> ((Level)this.level).getBlockEntity(arg_0)).anyMatch(be -> !(be instanceof MarkedPedestalBlockEntity) || be.isRemoved())) {
            this.endProcess();
            return;
        }
        for (BlockPos pedestalPos : this.pedestals) {
            BaseItemHandler pedestalInv = ((MarkedPedestalBlockEntity)this.level.getBlockEntity(pedestalPos)).getItemHandler();
            pedestalInv.setStackInSlot(0, MiscHelper.INSTANCE.getContainerItem(pedestalInv.getStackInSlot(0)));
            this.spawnParticles(ParticleTypes.SMOKE, pedestalPos, 1.1, 20);
        }
        this.itemHandler.setStackInSlot(0, ItemStack.EMPTY);
        this.spawnParticles(ParticleTypes.END_ROD, this.worldPosition, 1.1, 50);
        this.itemHandler.setStackInSlot(1, this.currentRecipe.getOutput());
        this.endProcess();
    }

    public void endProcess() {
        this.energyReq = 0L;
        this.remainingProgress = 0L;
        this.energyUsage = 0;
        this.pedestals.stream().map(arg_0 -> ((Level)this.level).getBlockEntity(arg_0)).filter(be -> be instanceof MarkedPedestalBlockEntity && !be.isRemoved()).forEach(be -> ((MarkedPedestalBlockEntity)((Object)be)).ejectItem());
        this.pedestals.clear();
        this.isWorking = false;
        this.currentRecipe = null;
        this.setChanged();
    }

    protected List<BlockPos> getEmptyPedestals() {
        return BlockPos.betweenClosedStream((BlockPos)this.worldPosition.offset(-3, 0, -3), (BlockPos)this.worldPosition.offset(3, 0, 3)).map(pos -> {
            MarkedPedestalBlockEntity pedestal;
            BlockEntity patt0$temp = this.level.getBlockEntity(pos);
            if (patt0$temp instanceof MarkedPedestalBlockEntity && (pedestal = (MarkedPedestalBlockEntity)patt0$temp).getItemHandler().getStackInSlot(0).isEmpty()) {
                return pos.immutable();
            }
            return null;
        }).filter((Predicate<BlockPos>)Predicates.notNull()).toList();
    }

    protected void ejectItems() {
        int endIndex = this.isWorking ? 1 : 0;
        for (Direction direction : Direction.values()) {
            BlockPos offsetPos = this.worldPosition.relative(direction);
            Block block = this.level.getBlockState(offsetPos).getBlock();
            IItemHandler itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, offsetPos, (Object)direction.getOpposite());
            if (block == PackagedAutoBlocks.UNPACKAGER.get() || itemHandler == null) continue;
            for (int i = 1; i >= endIndex; --i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                ItemStack stackRem = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
                this.itemHandler.setStackInSlot(i, stackRem);
            }
        }
    }

    protected void chargeEnergy() {
        ItemStack energyStack = this.itemHandler.getStackInSlot(2);
        IEnergyStorage itemEnergyStorage = (IEnergyStorage)energyStack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (itemEnergyStorage != null) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(itemEnergyStorage.extractEnergy(energyRequest, false), false);
            if (energyStack.getCount() <= 0) {
                this.itemHandler.setStackInSlot(2, ItemStack.EMPTY);
            }
        }
    }

    protected <T extends ParticleOptions> void spawnParticles(T particle, BlockPos pos, double yOffset, int count) {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.level;
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + yOffset;
        double z = (double)pos.getZ() + 0.5;
        level.sendParticles(particle, x, y, z, count, 0.0, 0.0, 0.0, 0.1);
    }

    protected void spawnItemParticles(BlockPos pedestalPos, ItemStack stack) {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.level;
        double x = (double)pedestalPos.getX() + level.getRandom().nextDouble() * 0.2 + 0.4;
        double y = (double)pedestalPos.getY() + level.getRandom().nextDouble() * 0.2 + 1.4;
        double z = (double)pedestalPos.getZ() + level.getRandom().nextDouble() * 0.2 + 0.4;
        double velX = this.worldPosition.getX() - pedestalPos.getX();
        double velY = 0.25;
        double velZ = this.worldPosition.getZ() - pedestalPos.getZ();
        level.sendParticles((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, stack), x, y, z, 0, velX, velY, velZ, 0.18);
    }

    protected boolean shouldSpawnItemParticles() {
        return this.remainingProgress < (long)(this.energyUsage * 40);
    }

    public int getComparatorSignal() {
        if (this.isWorking) {
            return 1;
        }
        if (!this.itemHandler.getStacks().subList(0, 2).stream().allMatch(ItemStack::isEmpty)) {
            return 15;
        }
        return 0;
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        this.isWorking = nbt.getBoolean("working");
        this.remainingProgress = nbt.getLong("progress");
        this.energyReq = nbt.getLong("energy_req");
        this.energyUsage = nbt.getInt("energy_usage");
        this.currentRecipe = null;
        if (nbt.contains("recipe")) {
            CompoundTag tag = nbt.getCompound("recipe");
            IPackageRecipeInfo recipe = MiscHelper.INSTANCE.loadRecipe(tag, registries);
            if (recipe instanceof ICombinationPackageRecipeInfo) {
                ICombinationPackageRecipeInfo combinationRecipe;
                this.currentRecipe = combinationRecipe = (ICombinationPackageRecipeInfo)recipe;
            }
            this.pedestals.clear();
            ListTag pedestalsTag = nbt.getList("pedestals", 11);
            for (int i = 0; i < pedestalsTag.size(); ++i) {
                int[] posArray = pedestalsTag.getIntArray(i);
                BlockPos pos = new BlockPos(posArray[0], posArray[1], posArray[2]);
                this.pedestals.add(pos);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.rewriteExpressions(StructuredExpressionStatement.java:70)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void loadSync(CompoundTag nbt, HolderLookup.Provider registries) {
        super.loadSync(nbt, registries);
        this.itemHandler.load(nbt, registries);
    }

    public CompoundTag saveSync(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveSync(nbt, registries);
        this.itemHandler.save(nbt, registries);
        return nbt;
    }

    public int getScaledEnergy(int scale) {
        if (this.energyStorage.getMaxEnergyStored() <= 0) {
            return 0;
        }
        return Math.min(scale * this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored(), scale);
    }

    public int getScaledProgress(int scale) {
        if (this.remainingProgress <= 0L || this.energyReq <= 0L) {
            return 0;
        }
        return (int)((long)scale * (this.energyReq - this.remainingProgress) / this.energyReq);
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
        this.sync(false);
        return new CombinationCrafterMenu(windowId, inventory, this);
    }

    private static /* synthetic */ void lambda$saveAdditional$6(ListTag pedestalsTag, int[] arr) {
        pedestalsTag.add((Object)new IntArrayTag(arr));
    }
}

