/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedexcrafting.block.entity;

import com.blakebr0.extendedcrafting.block.EnderAlternatorBlock;
import com.google.common.base.Predicates;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.block.PackagedAutoBlocks;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedexcrafting.block.entity.PackagedExCraftingBlockEntities;
import thelm.packagedexcrafting.inventory.EnderCrafterItemHandler;
import thelm.packagedexcrafting.menu.EnderCrafterMenu;
import thelm.packagedexcrafting.recipe.IEnderPackageRecipeInfo;

public class EnderCrafterBlockEntity
extends BaseBlockEntity
implements IPackageCraftingMachine {
    public static int energyCapacity = 5000;
    public static double alternatorEff = 0.02;
    public static int energyReq = 500;
    public static int energyUsage = 100;
    public static boolean drawMEEnergy = true;
    public boolean isWorking = false;
    public int progressReq = 0;
    public int progress = 0;
    public int actualProgressReq = 0;
    public int remainingProgress = 0;
    public IEnderPackageRecipeInfo currentRecipe;

    public EnderCrafterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PackagedExCraftingBlockEntities.ENDER_CRAFTER.get(), pos, state);
        this.setItemHandler(new EnderCrafterItemHandler(this));
        this.setEnergyStorage(new EnergyStorage((BaseBlockEntity)this, energyCapacity));
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.packagedexcrafting.ender_crafter");
    }

    public void tick() {
        if (!this.level.isClientSide) {
            if (this.isWorking) {
                this.tickProcess();
                if (this.remainingProgress <= 0) {
                    this.finishProcess();
                    this.ejectItems();
                }
            }
            this.chargeEnergy();
            if (this.level.getGameTime() % 8L == 0L) {
                this.ejectItems();
            }
        }
    }

    public boolean acceptPackage(IPackageRecipeInfo recipeInfo, List<ItemStack> stacks, Direction direction) {
        if (!this.isBusy() && recipeInfo.isValid() && recipeInfo instanceof IEnderPackageRecipeInfo) {
            IEnderPackageRecipeInfo recipe = (IEnderPackageRecipeInfo)recipeInfo;
            ItemStack slotStack = this.itemHandler.getStackInSlot(9);
            ItemStack outputStack = recipe.getOutput();
            if (slotStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)outputStack) && slotStack.getCount() + outputStack.getCount() <= outputStack.getMaxStackSize()) {
                this.currentRecipe = recipe;
                this.isWorking = true;
                this.progressReq = recipe.getTimeRequired() * 20;
                this.remainingProgress = energyReq;
                CraftingInput matrix = recipe.getMatrix();
                for (int i = 0; i < matrix.height(); ++i) {
                    for (int j = 0; j < matrix.width(); ++j) {
                        this.itemHandler.setStackInSlot(i * 3 + j, matrix.getItem(i * matrix.width() + j).copy());
                    }
                }
                this.setChanged();
                return true;
            }
        }
        return false;
    }

    public boolean isBusy() {
        return this.isWorking || !this.itemHandler.getStacks().subList(0, 9).stream().allMatch(ItemStack::isEmpty);
    }

    protected void tickProcess() {
        List<BlockPos> alternators = this.getAlternators();
        int alternatorCount = alternators.size();
        if (alternatorCount > 0) {
            ++this.progress;
            this.actualProgressReq = (int)Math.max((double)this.progressReq * (1.0 - alternatorEff * (double)alternatorCount), 0.0);
            for (BlockPos alternatorPos : alternators) {
                if (!this.level.isEmptyBlock(alternatorPos.above())) continue;
                this.spawnParticles(ParticleTypes.PORTAL, alternatorPos, 1.0, 1);
            }
        } else {
            this.actualProgressReq = this.progressReq;
        }
        if (this.progress >= this.actualProgressReq) {
            this.progress = this.actualProgressReq;
            int energy = this.energyStorage.extractEnergy(Math.min(energyUsage, this.remainingProgress), false);
            this.remainingProgress -= energy;
        }
    }

    protected void finishProcess() {
        if (this.currentRecipe == null) {
            this.endProcess();
            return;
        }
        if (this.itemHandler.getStackInSlot(9).isEmpty()) {
            this.itemHandler.setStackInSlot(9, this.currentRecipe.getOutput());
        } else {
            this.itemHandler.getStackInSlot(9).grow(this.currentRecipe.getOutput().getCount());
        }
        List<ItemStack> remainingItems = this.currentRecipe.getRemainingItems();
        CraftingInput matrix = this.currentRecipe.getMatrix();
        for (int i = 0; i < matrix.height(); ++i) {
            for (int j = 0; j < matrix.width(); ++j) {
                this.itemHandler.setStackInSlot(i * 3 + j, remainingItems.get(i * matrix.width() + j));
            }
        }
        this.endProcess();
    }

    public void endProcess() {
        this.progressReq = 0;
        this.progress = 0;
        this.remainingProgress = 0;
        this.isWorking = false;
        this.currentRecipe = null;
        this.setChanged();
    }

    protected List<BlockPos> getAlternators() {
        return BlockPos.betweenClosedStream((BlockPos)this.worldPosition.offset(-3, -3, -3), (BlockPos)this.worldPosition.offset(3, 3, 3)).map(pos -> {
            if (this.level.getBlockState(pos).getBlock() instanceof EnderAlternatorBlock) {
                return pos.immutable();
            }
            return null;
        }).filter((Predicate<BlockPos>)Predicates.notNull()).toList();
    }

    protected void ejectItems() {
        int endIndex = this.isWorking ? 9 : 0;
        for (Direction direction : Direction.values()) {
            BlockPos offsetPos = this.worldPosition.relative(direction);
            Block block = this.level.getBlockState(offsetPos).getBlock();
            IItemHandler itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, offsetPos, (Object)direction.getOpposite());
            if (block == PackagedAutoBlocks.UNPACKAGER.get() || itemHandler == null) continue;
            for (int i = 9; i >= endIndex; --i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                ItemStack stackRem = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
                this.itemHandler.setStackInSlot(i, stackRem);
            }
        }
    }

    protected void chargeEnergy() {
        ItemStack energyStack = this.itemHandler.getStackInSlot(10);
        IEnergyStorage itemEnergyStorage = (IEnergyStorage)energyStack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (itemEnergyStorage != null) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(itemEnergyStorage.extractEnergy(energyRequest, false), false);
            if (energyStack.getCount() <= 0) {
                this.itemHandler.setStackInSlot(10, ItemStack.EMPTY);
            }
        }
    }

    protected <T extends ParticleOptions> void spawnParticles(T particle, BlockPos pos, double yOffset, int count) {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        ServerLevel level = (ServerLevel)this.level;
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + yOffset;
        double z = (double)pos.getZ() + 0.5;
        level.sendParticles(particle, x, y, z, count, 0.0, 0.0, 0.0, 0.1);
    }

    public int getComparatorSignal() {
        if (this.isWorking) {
            return 1;
        }
        if (!this.itemHandler.getStacks().subList(0, 10).stream().allMatch(ItemStack::isEmpty)) {
            return 15;
        }
        return 0;
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        CompoundTag tag;
        IPackageRecipeInfo recipe;
        super.loadAdditional(nbt, registries);
        this.isWorking = nbt.getBoolean("working");
        this.progressReq = nbt.getInt("progress_req");
        this.progress = nbt.getInt("progress");
        this.remainingProgress = nbt.getInt("energy_progress");
        this.currentRecipe = null;
        if (nbt.contains("recipe") && (recipe = MiscHelper.INSTANCE.loadRecipe(tag = nbt.getCompound("recipe"), registries)) instanceof IEnderPackageRecipeInfo) {
            IEnderPackageRecipeInfo enderRecipe;
            this.currentRecipe = enderRecipe = (IEnderPackageRecipeInfo)recipe;
        }
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putBoolean("working", this.isWorking);
        nbt.putInt("progress_req", this.progressReq);
        nbt.putInt("progress", this.progress);
        nbt.putInt("energy_progress", this.remainingProgress);
        if (this.currentRecipe != null) {
            CompoundTag tag = MiscHelper.INSTANCE.saveRecipe(new CompoundTag(), (IPackageRecipeInfo)this.currentRecipe, registries);
            nbt.put("recipe", (Tag)tag);
        }
    }

    public int getScaledEnergy(int scale) {
        if (this.energyStorage.getMaxEnergyStored() <= 0) {
            return 0;
        }
        return Math.min(scale * this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored(), scale);
    }

    public int getScaledProgress(int scale) {
        if (this.progress <= 0 || this.actualProgressReq <= 0) {
            return 0;
        }
        return scale * this.progress / this.actualProgressReq;
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
        this.sync(false);
        return new EnderCrafterMenu(windowId, inventory, this);
    }
}

