/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedexcrafting.block.entity;

import com.blakebr0.extendedcrafting.api.TableCraftingInput;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import thelm.packagedauto.api.IPackageCraftingMachine;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.block.PackagedAutoBlocks;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.energy.EnergyStorage;
import thelm.packagedauto.util.MiscHelper;
import thelm.packagedexcrafting.block.entity.PackagedExCraftingBlockEntities;
import thelm.packagedexcrafting.inventory.UltimateCrafterItemHandler;
import thelm.packagedexcrafting.menu.UltimateCrafterMenu;
import thelm.packagedexcrafting.recipe.ITablePackageRecipeInfo;

public class UltimateCrafterBlockEntity
extends BaseBlockEntity
implements IPackageCraftingMachine {
    public static int energyCapacity = 5000;
    public static int energyReq = 5000;
    public static int energyUsage = 500;
    public static boolean drawMEEnergy = true;
    public boolean isWorking = false;
    public int remainingProgress = 0;
    public ITablePackageRecipeInfo currentRecipe;

    public UltimateCrafterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)PackagedExCraftingBlockEntities.ULTIMATE_CRAFTER.get(), pos, state);
        this.setItemHandler(new UltimateCrafterItemHandler(this));
        this.setEnergyStorage(new EnergyStorage((BaseBlockEntity)this, energyCapacity));
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.packagedexcrafting.ultimate_crafter");
    }

    public void tick() {
        if (!this.level.isClientSide) {
            if (this.isWorking) {
                this.tickProcess();
                if (this.remainingProgress <= 0) {
                    this.finishProcess();
                    this.ejectItems();
                }
            }
            this.chargeEnergy();
            if (this.level.getGameTime() % 8L == 0L) {
                this.ejectItems();
            }
        }
    }

    public boolean acceptPackage(IPackageRecipeInfo recipeInfo, List<ItemStack> stacks, Direction direction) {
        ITablePackageRecipeInfo recipe;
        if (!this.isBusy() && recipeInfo.isValid() && recipeInfo instanceof ITablePackageRecipeInfo && (recipe = (ITablePackageRecipeInfo)recipeInfo).getTier() == 4) {
            ItemStack slotStack = this.itemHandler.getStackInSlot(81);
            ItemStack outputStack = recipe.getOutput();
            if (slotStack.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)slotStack, (ItemStack)outputStack) && slotStack.getCount() + outputStack.getCount() <= outputStack.getMaxStackSize()) {
                this.currentRecipe = recipe;
                this.isWorking = true;
                this.remainingProgress = energyReq;
                TableCraftingInput matrix = recipe.getMatrix();
                for (int i = 0; i < matrix.height(); ++i) {
                    for (int j = 0; j < matrix.width(); ++j) {
                        this.itemHandler.setStackInSlot(i * 9 + j, matrix.getItem(i * matrix.width() + j).copy());
                    }
                }
                this.setChanged();
                return true;
            }
        }
        return false;
    }

    public boolean isBusy() {
        return this.isWorking || !this.itemHandler.getStacks().subList(0, 81).stream().allMatch(ItemStack::isEmpty);
    }

    protected void tickProcess() {
        int energy = this.energyStorage.extractEnergy(Math.min(energyUsage, this.remainingProgress), false);
        this.remainingProgress -= energy;
    }

    protected void finishProcess() {
        if (this.currentRecipe == null) {
            this.endProcess();
            return;
        }
        if (this.itemHandler.getStackInSlot(81).isEmpty()) {
            this.itemHandler.setStackInSlot(81, this.currentRecipe.getOutput());
        } else {
            this.itemHandler.getStackInSlot(81).grow(this.currentRecipe.getOutput().getCount());
        }
        List<ItemStack> remainingItems = this.currentRecipe.getRemainingItems();
        TableCraftingInput matrix = this.currentRecipe.getMatrix();
        for (int i = 0; i < matrix.height(); ++i) {
            for (int j = 0; j < matrix.width(); ++j) {
                this.itemHandler.setStackInSlot(i * 9 + j, remainingItems.get(i * matrix.width() + j));
            }
        }
        this.endProcess();
    }

    public void endProcess() {
        this.remainingProgress = 0;
        this.isWorking = false;
        this.currentRecipe = null;
        this.setChanged();
    }

    protected void ejectItems() {
        int endIndex = this.isWorking ? 81 : 0;
        for (Direction direction : Direction.values()) {
            BlockPos offsetPos = this.worldPosition.relative(direction);
            Block block = this.level.getBlockState(offsetPos).getBlock();
            IItemHandler itemHandler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, offsetPos, (Object)direction.getOpposite());
            if (block == PackagedAutoBlocks.UNPACKAGER.get() || itemHandler == null) continue;
            for (int i = 81; i >= endIndex; --i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                ItemStack stackRem = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false);
                this.itemHandler.setStackInSlot(i, stackRem);
            }
        }
    }

    protected void chargeEnergy() {
        ItemStack energyStack = this.itemHandler.getStackInSlot(82);
        IEnergyStorage itemEnergyStorage = (IEnergyStorage)energyStack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (itemEnergyStorage != null) {
            int energyRequest = Math.min(this.energyStorage.getMaxReceive(), this.energyStorage.getMaxEnergyStored() - this.energyStorage.getEnergyStored());
            this.energyStorage.receiveEnergy(itemEnergyStorage.extractEnergy(energyRequest, false), false);
            if (energyStack.getCount() <= 0) {
                this.itemHandler.setStackInSlot(82, ItemStack.EMPTY);
            }
        }
    }

    public int getComparatorSignal() {
        if (this.isWorking) {
            return 1;
        }
        if (!this.itemHandler.getStacks().subList(0, 82).stream().allMatch(ItemStack::isEmpty)) {
            return 15;
        }
        return 0;
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        ITablePackageRecipeInfo tableRecipe;
        CompoundTag tag;
        IPackageRecipeInfo recipe;
        super.loadAdditional(nbt, registries);
        this.currentRecipe = null;
        this.isWorking = nbt.getBoolean("working");
        this.remainingProgress = nbt.getInt("progress");
        if (nbt.contains("recipe") && (recipe = MiscHelper.INSTANCE.loadRecipe(tag = nbt.getCompound("recipe"), registries)) instanceof ITablePackageRecipeInfo && (tableRecipe = (ITablePackageRecipeInfo)recipe).getTier() == 4) {
            this.currentRecipe = tableRecipe;
        }
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        nbt.putBoolean("working", this.isWorking);
        nbt.putInt("progress", this.remainingProgress);
        if (this.currentRecipe != null) {
            CompoundTag tag = MiscHelper.INSTANCE.saveRecipe(new CompoundTag(), (IPackageRecipeInfo)this.currentRecipe, registries);
            nbt.put("recipe", (Tag)tag);
        }
    }

    public int getScaledEnergy(int scale) {
        if (this.energyStorage.getMaxEnergyStored() <= 0) {
            return 0;
        }
        return Math.min(scale * this.energyStorage.getEnergyStored() / this.energyStorage.getMaxEnergyStored(), scale);
    }

    public int getScaledProgress(int scale) {
        if (this.remainingProgress <= 0 || energyReq <= 0) {
            return 0;
        }
        return scale * (energyReq - this.remainingProgress) / energyReq;
    }

    public AbstractContainerMenu createMenu(int windowId, Inventory inventory, Player player) {
        this.sync(false);
        return new UltimateCrafterMenu(windowId, inventory, this);
    }
}

