/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedexcrafting.inventory;

import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packagedexcrafting.block.entity.EliteCrafterBlockEntity;
import thelm.packagedexcrafting.inventory.EliteCrafterItemHandlerWrapper;

public class EliteCrafterItemHandler
extends BaseItemHandler<EliteCrafterBlockEntity> {
    public EliteCrafterItemHandler(EliteCrafterBlockEntity blockEntity) {
        super((BaseBlockEntity)blockEntity, 51);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot == 50) {
            return stack.getCapability(Capabilities.EnergyStorage.ITEM) != null;
        }
        return false;
    }

    public IItemHandlerModifiable getWrapperForDirection(Direction side) {
        return this.wrapperMap.computeIfAbsent(side, s -> new EliteCrafterItemHandlerWrapper(this, (Direction)s));
    }

    public int get(int id) {
        return switch (id) {
            case 0 -> ((EliteCrafterBlockEntity)this.blockEntity).remainingProgress;
            case 1 -> {
                if (((EliteCrafterBlockEntity)this.blockEntity).isWorking) {
                    yield 1;
                }
                yield 0;
            }
            case 2 -> ((EliteCrafterBlockEntity)this.blockEntity).getEnergyStorage().getEnergyStored();
            default -> 0;
        };
    }

    public void set(int id, int value) {
        switch (id) {
            case 0: {
                ((EliteCrafterBlockEntity)this.blockEntity).remainingProgress = value;
                break;
            }
            case 1: {
                ((EliteCrafterBlockEntity)this.blockEntity).isWorking = value != 0;
                break;
            }
            case 2: {
                ((EliteCrafterBlockEntity)this.blockEntity).getEnergyStorage().setEnergyStored(value);
            }
        }
    }

    public int getCount() {
        return 3;
    }
}

