/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedexcrafting.inventory;

import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import thelm.packagedauto.block.entity.BaseBlockEntity;
import thelm.packagedauto.inventory.BaseItemHandler;
import thelm.packagedexcrafting.block.entity.UltimateCrafterBlockEntity;
import thelm.packagedexcrafting.inventory.UltimateCrafterItemHandlerWrapper;

public class UltimateCrafterItemHandler
extends BaseItemHandler<UltimateCrafterBlockEntity> {
    public UltimateCrafterItemHandler(UltimateCrafterBlockEntity blockEntity) {
        super((BaseBlockEntity)blockEntity, 83);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot == 82) {
            return stack.getCapability(Capabilities.EnergyStorage.ITEM) != null;
        }
        return false;
    }

    public IItemHandlerModifiable getWrapperForDirection(Direction side) {
        return this.wrapperMap.computeIfAbsent(side, s -> new UltimateCrafterItemHandlerWrapper(this, (Direction)s));
    }

    public int get(int id) {
        return switch (id) {
            case 0 -> ((UltimateCrafterBlockEntity)this.blockEntity).remainingProgress;
            case 1 -> {
                if (((UltimateCrafterBlockEntity)this.blockEntity).isWorking) {
                    yield 1;
                }
                yield 0;
            }
            case 2 -> ((UltimateCrafterBlockEntity)this.blockEntity).getEnergyStorage().getEnergyStored();
            default -> 0;
        };
    }

    public void set(int id, int value) {
        switch (id) {
            case 0: {
                ((UltimateCrafterBlockEntity)this.blockEntity).remainingProgress = value;
                break;
            }
            case 1: {
                ((UltimateCrafterBlockEntity)this.blockEntity).isWorking = value != 0;
                break;
            }
            case 2: {
                ((UltimateCrafterBlockEntity)this.blockEntity).getEnergyStorage().setEnergyStored(value);
            }
        }
    }

    public int getCount() {
        return 3;
    }
}

