/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedexcrafting.recipe;

import com.blakebr0.extendedcrafting.init.ModBlocks;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import thelm.packagedauto.api.IPackageRecipeInfo;
import thelm.packagedauto.api.IPackageRecipeType;
import thelm.packagedauto.api.IRecipeSlotViewWrapper;
import thelm.packagedauto.api.IRecipeSlotsViewWrapper;
import thelm.packagedexcrafting.recipe.BasicPackageRecipeInfo;

public class BasicPackageRecipeType
implements IPackageRecipeType {
    public static final BasicPackageRecipeType INSTANCE = new BasicPackageRecipeType();
    public static final ResourceLocation NAME = ResourceLocation.parse((String)"packagedexcrafting:basic");
    public static final IntSet SLOTS;
    public static final List<ResourceLocation> CATEGORIES;
    public static final Vec3i COLOR;
    public static final Vec3i COLOR_DISABLED;

    protected BasicPackageRecipeType() {
    }

    public ResourceLocation getName() {
        return NAME;
    }

    public MutableComponent getDisplayName() {
        return Component.translatable((String)"recipe.packagedexcrafting.basic");
    }

    public MutableComponent getShortDisplayName() {
        return Component.translatable((String)"recipe.packagedexcrafting.basic.short");
    }

    public MapCodec<? extends IPackageRecipeInfo> getRecipeInfoMapCodec() {
        return BasicPackageRecipeInfo.MAP_CODEC;
    }

    public Codec<? extends IPackageRecipeInfo> getRecipeInfoCodec() {
        return BasicPackageRecipeInfo.CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, ? extends IPackageRecipeInfo> getRecipeInfoStreamCodec() {
        return BasicPackageRecipeInfo.STREAM_CODEC;
    }

    public IPackageRecipeInfo generateRecipeInfoFromStacks(List<ItemStack> inputs, List<ItemStack> outputs, Level level) {
        return new BasicPackageRecipeInfo(inputs, level);
    }

    public IntSet getEnabledSlots() {
        return SLOTS;
    }

    public List<ResourceLocation> getJEICategories() {
        return CATEGORIES;
    }

    public Int2ObjectMap<ItemStack> getRecipeTransferMap(IRecipeSlotsViewWrapper recipeLayoutWrapper) {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        List slotViews = recipeLayoutWrapper.getRecipeSlotViews();
        int index = 0;
        int[] slotArray = SLOTS.toIntArray();
        for (IRecipeSlotViewWrapper slotView : slotViews) {
            if (slotView.isInput()) {
                ItemStack stack;
                Object displayed = slotView.getDisplayedIngredient().orElse(null);
                if (displayed instanceof ItemStack && !(stack = (ItemStack)displayed).isEmpty()) {
                    map.put(slotArray[index], (Object)stack);
                }
                ++index;
            }
            if (index < 9) continue;
            break;
        }
        return map;
    }

    public Object getRepresentation() {
        return new ItemStack((ItemLike)ModBlocks.BASIC_TABLE.get());
    }

    public Vec3i getSlotColor(int slot) {
        if (!SLOTS.contains(slot) && slot != 81) {
            return COLOR_DISABLED;
        }
        return COLOR;
    }

    static {
        CATEGORIES = List.of(ResourceLocation.parse((String)"extendedcrafting:basic_crafting"));
        COLOR = new Vec3i(139, 139, 139);
        COLOR_DISABLED = new Vec3i(64, 64, 64);
        SLOTS = new IntRBTreeSet();
        for (int i = 3; i < 6; ++i) {
            for (int j = 3; j < 6; ++j) {
                SLOTS.add(9 * i + j);
            }
        }
    }
}

